/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services.views;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.ViewVersionResponse;
import id.onyx.obdp.server.controller.spi.Resource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;

@Path(value="/views/{viewName}/versions")
@Api(value="Views", description="Endpoint for view specific operations")
public class ViewVersionService
extends BaseService {
    @GET
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get all versions for a view", response=ViewVersionResponse.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", defaultValue="ViewVersionInfo/*", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort resources in result by (asc | desc)", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive).  \"start\" is also accepted.", allowableValues="range[0, infinity]", defaultValue="0", dataType="integer", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive).  \"end\" is also accepted.", allowableValues="range[1, infinity]", dataType="integer", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="Cluster not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid arguments")})
    public Response getVersions(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="view name") @PathParam(value="viewName") String viewName) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createResource(viewName, null));
    }

    @GET
    @Path(value="{version}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get single view version", response=ViewVersionResponse.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", defaultValue="ViewVersionInfo/*", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="Cluster not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid arguments")})
    public Response getVersion(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="view name") @PathParam(value="viewName") String viewName, @PathParam(value="version") String version) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createResource(viewName, version));
    }

    @POST
    @Path(value="{version}")
    @Produces(value={"text/plain"})
    public Response createVersions(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="view name") @PathParam(value="viewName") String viewName, @PathParam(value="version") String version) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createResource(viewName, version));
    }

    @PUT
    @Path(value="{version}")
    @Produces(value={"text/plain"})
    public Response updateVersions(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="view name") @PathParam(value="viewName") String viewName, @PathParam(value="version") String version) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createResource(viewName, version));
    }

    @DELETE
    @Path(value="{version}")
    @Produces(value={"text/plain"})
    public Response deleteVersions(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="viewName") String viewName, @PathParam(value="version") String version) {
        return this.handleRequest(headers, null, ui, Request.Type.DELETE, this.createResource(viewName, version));
    }

    private ResourceInstance createResource(String viewName, String version) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.View, viewName);
        mapIds.put(Resource.Type.ViewVersion, version);
        return this.createResource(Resource.Type.ViewVersion, mapIds);
    }
}

