/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services.views;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.ViewUrlResponseSwagger;
import id.onyx.obdp.server.controller.spi.Resource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collections;

@Path(value="/view/urls")
@Api(value="Views", description="Endpoint for view specific operations")
public class ViewUrlsService
extends BaseService {
    private static final String VIEW_URL_INFO_TYPE = "id.onyx.obdp.server.controller.ViewUrlResponseSwagger";

    @GET
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get all view URLs", response=ViewUrlResponseSwagger.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", defaultValue="ViewUrlInfo/*", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort resources in result by (asc | desc)", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive).  \"start\" is also accepted.", allowableValues="range[0, infinity]", defaultValue="0", dataType="integer", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive).  \"end\" is also accepted.", allowableValues="range[1, infinity]", dataType="integer", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="Cluster not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid arguments")})
    public Response getViewUrls(@Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createViewUrlResource(null));
    }

    @POST
    @Path(value="{urlName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Create view URL")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.ViewUrlResponseSwagger", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=201, message="Successful operation"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=500, message="Internal server error")})
    public Response createUrl(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="urlName") String urlName) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createViewUrlResource(urlName));
    }

    @PUT
    @Path(value="{urlName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Update view URL")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.ViewUrlResponseSwagger", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=404, message="Cluster or host not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateUrl(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="urlName") String urlName) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createViewUrlResource(urlName));
    }

    @GET
    @Path(value="{urlName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get single view URL", nickname="getViewUrl", response=ViewUrlResponseSwagger.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", defaultValue="ViewUrlInfo/*", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="Cluster not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid arguments")})
    public Response getUrl(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="urlName") String urlName) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createViewUrlResource(urlName));
    }

    @DELETE
    @Path(value="{urlName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Delete view URL")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="Cluster or host not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteUrl(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="urlName") String urlName) {
        return this.handleRequest(headers, body, ui, Request.Type.DELETE, this.createViewUrlResource(urlName));
    }

    private ResourceInstance createViewUrlResource(String urlName) {
        return this.createResource(Resource.Type.ViewURL, Collections.singletonMap(Resource.Type.ViewURL, urlName));
    }
}

