/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services.views;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.orm.entities.ViewEntity;
import id.onyx.obdp.server.orm.entities.ViewInstanceEntity;
import id.onyx.obdp.view.ViewResourceHandler;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;

public class ViewSubResourceService
extends BaseService
implements ViewResourceHandler {
    private final Resource.Type type;
    private final String viewName;
    private final String version;
    private final String instanceName;

    public ViewSubResourceService(Resource.Type type, ViewInstanceEntity viewInstanceDefinition) {
        ViewEntity viewEntity = viewInstanceDefinition.getViewEntity();
        this.type = type;
        this.viewName = viewEntity.getCommonName();
        this.version = viewEntity.getVersion();
        this.instanceName = viewInstanceDefinition.getName();
    }

    public Response handleRequest(HttpHeaders headers, UriInfo ui, ViewResourceHandler.RequestType requestType, ViewResourceHandler.MediaType mediaType, String resourceId) {
        return this.handleRequest(headers, null, ui, this.getRequestType(requestType), this.getMediaType(mediaType), this.createResource(resourceId));
    }

    public Response handleRequest(HttpHeaders headers, UriInfo ui, String resourceId) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createResource(resourceId));
    }

    protected ResourceInstance createResource(String resourceId) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.View, this.viewName);
        mapIds.put(Resource.Type.ViewVersion, this.version);
        mapIds.put(Resource.Type.ViewInstance, this.instanceName);
        if (resourceId != null) {
            mapIds.put(this.type, resourceId);
        }
        return super.createResource(this.type, mapIds);
    }

    private Request.Type getRequestType(ViewResourceHandler.RequestType type) {
        switch (type) {
            case GET: {
                return Request.Type.GET;
            }
            case POST: {
                return Request.Type.POST;
            }
            case PUT: {
                return Request.Type.PUT;
            }
            case DELETE: {
                return Request.Type.DELETE;
            }
            case QUERY_POST: {
                return Request.Type.QUERY_POST;
            }
        }
        throw new IllegalArgumentException("Unknown resource type " + type);
    }

    private MediaType getMediaType(ViewResourceHandler.MediaType type) {
        switch (type) {
            case TEXT_PLAIN: {
                return MediaType.TEXT_PLAIN_TYPE;
            }
            case APPLICATION_JSON: {
                return MediaType.APPLICATION_JSON_TYPE;
            }
        }
        throw new IllegalArgumentException("Unknown media type " + type);
    }
}

