/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services.views;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.ViewResponse;
import id.onyx.obdp.server.controller.spi.Resource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collections;

@Path(value="/views/")
@Api(value="Views", description="Endpoint for view specific operations")
public class ViewService
extends BaseService {
    @GET
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get all views", nickname="getViews", notes="Returns details of all views.", response=ViewResponse.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", defaultValue="Views/*", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort resources in result by (asc | desc)", defaultValue="Views/view_name.asc", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive).  \"start\" is also accepted.", allowableValues="range[0, infinity]", defaultValue="0", dataType="integer", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive).  \"end\" is also accepted.", allowableValues="range[1, infinity]", dataType="integer", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="Cluster not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid arguments")})
    public Response getViews(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createViewResource(null));
    }

    @GET
    @Path(value="{viewName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get single view", response=ViewResponse.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", defaultValue="Views/*", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="Cluster or host not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid arguments")})
    public Response getView(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="view name", required=true) @PathParam(value="viewName") String viewName) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createViewResource(viewName));
    }

    @POST
    @Path(value="{viewName}")
    @Produces(value={"text/plain"})
    public Response createView(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="viewName") String viewName) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createViewResource(viewName));
    }

    @PUT
    @Path(value="{viewName}")
    @Produces(value={"text/plain"})
    public Response updateView(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="view name", required=true) @PathParam(value="viewName") String viewName) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createViewResource(viewName));
    }

    @DELETE
    @Path(value="{viewName}")
    @Produces(value={"text/plain"})
    public Response deleteView(@Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="view name", required=true) @PathParam(value="viewName") String viewName) {
        return this.handleRequest(headers, null, ui, Request.Type.DELETE, this.createViewResource(viewName));
    }

    private ResourceInstance createViewResource(String viewName) {
        return this.createResource(Resource.Type.View, Collections.singletonMap(Resource.Type.View, viewName));
    }
}

