/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services.views;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.ViewPrivilegeResponse;
import id.onyx.obdp.server.controller.spi.Resource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;

@Path(value="/views/{viewName}/versions/{version}/instances/{instanceName}/privileges")
@Api(tags={"Views"}, description="Endpoint for view specific operations")
public class ViewPrivilegeService
extends BaseService {
    public static final String PRIVILEGE_INFO_REQUEST_TYPE = "id.onyx.obdp.server.controller.ViewPrivilegeResponse.ViewPrivilegeResponseWrapper";

    @GET
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get all view instance privileges", response=ViewPrivilegeResponse.ViewPrivilegeResponseWrapper.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", defaultValue="PrivilegeInfo/*", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort resources in result by (asc | desc)", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive).  \"start\" is also accepted.", allowableValues="range[0, infinity]", defaultValue="0", dataType="integer", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive).  \"end\" is also accepted.", allowableValues="range[1, infinity]", dataType="integer", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="Cluster not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid arguments")})
    public Response getPrivileges(@Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="view name") @PathParam(value="viewName") String viewName, @ApiParam(value="view version") @PathParam(value="version") String version, @ApiParam(value="instance name") @PathParam(value="instanceName") String instanceName) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createPrivilegeResource(viewName, version, instanceName, null));
    }

    @GET
    @Path(value="/{privilegeId}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get single view instance privilege", response=ViewPrivilegeResponse.ViewPrivilegeResponseWrapper.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", defaultValue="PrivilegeInfo/*", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="Cluster or host not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid arguments")})
    public Response getPrivilege(@Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="view name") @PathParam(value="viewName") String viewName, @ApiParam(value="view version") @PathParam(value="version") String version, @ApiParam(value="instance name") @PathParam(value="instanceName") String instanceName, @ApiParam(value="privilege id", required=true) @PathParam(value="privilegeId") String privilegeId) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createPrivilegeResource(viewName, version, instanceName, privilegeId));
    }

    @POST
    @Produces(value={"text/plain"})
    @ApiOperation(value="Create view instance privilege")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.ViewPrivilegeResponse.ViewPrivilegeResponseWrapper", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=201, message="Successful operation"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=500, message="Internal server error")})
    public Response createPrivilege(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="view name") @PathParam(value="viewName") String viewName, @ApiParam(value="view version") @PathParam(value="version") String version, @ApiParam(value="instance name") @PathParam(value="instanceName") String instanceName) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createPrivilegeResource(viewName, version, instanceName, null));
    }

    @PUT
    public Response updatePrivilege(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="view name") @PathParam(value="viewName") String viewName, @ApiParam(value="view version") @PathParam(value="version") String version, @ApiParam(value="instance name") @PathParam(value="instanceName") String instanceName, @ApiParam(value="privilege id") @PathParam(value="privilegeId") String privilegeId) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createPrivilegeResource(viewName, version, instanceName, privilegeId));
    }

    @PUT
    @Produces(value={"text/plain"})
    @ApiOperation(value="Update view instance privilege")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.ViewPrivilegeResponse.ViewPrivilegeResponseWrapper", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=404, message="Cluster or host not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updatePrivileges(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="view name") @PathParam(value="viewName") String viewName, @ApiParam(value="view version") @PathParam(value="version") String version, @ApiParam(value="instance name") @PathParam(value="instanceName") String instanceName) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createPrivilegeResource(viewName, version, instanceName, null));
    }

    @DELETE
    @Produces(value={"text/plain"})
    @ApiOperation(value="Delete view instance privileges")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="Cluster or host not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deletePrivileges(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="view name") @PathParam(value="viewName") String viewName, @ApiParam(value="view version") @PathParam(value="viewVersion") String version, @ApiParam(value="instance name") @PathParam(value="instanceName") String instanceName) {
        return this.handleRequest(headers, body, ui, Request.Type.DELETE, this.createPrivilegeResource(viewName, version, instanceName, null));
    }

    @DELETE
    @Path(value="{privilegeId}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Delete privileges")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="Cluster or host not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deletePrivilege(@Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="view name") @PathParam(value="viewName") String viewName, @ApiParam(value="view version") @PathParam(value="version") String version, @ApiParam(value="instance name") @PathParam(value="instanceName") String instanceName, @ApiParam(value="privilege id") @PathParam(value="privilegeId") String privilegeId) {
        return this.handleRequest(headers, null, ui, Request.Type.DELETE, this.createPrivilegeResource(viewName, version, instanceName, privilegeId));
    }

    protected ResourceInstance createPrivilegeResource(String viewName, String viewVersion, String instanceName, String privilegeId) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.View, viewName);
        mapIds.put(Resource.Type.ViewVersion, viewVersion);
        mapIds.put(Resource.Type.ViewInstance, instanceName);
        mapIds.put(Resource.Type.ViewPrivilege, privilegeId);
        return this.createResource(Resource.Type.ViewPrivilege, mapIds);
    }
}

