/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services.views;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.ViewPermissionResponse;
import id.onyx.obdp.server.controller.spi.Resource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;

@Path(value="/views/{viewName}/versions/{version}/permissions")
@Api(value="Views", description="Endpoint for view specific operations")
public class ViewPermissionService
extends BaseService {
    @GET
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get all permissions for a view", response=ViewPermissionResponse.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", defaultValue="PermissionInfo/*", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort resources in result by (asc | desc)", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive).  \"start\" is also accepted.", allowableValues="range[0, infinity]", defaultValue="0", dataType="integer", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive).  \"end\" is also accepted.", allowableValues="range[1, infinity]", dataType="integer", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="Cluster not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid arguments")})
    public Response getPermissions(@Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="view name") @PathParam(value="viewName") String viewName, @ApiParam(value="view version") @PathParam(value="version") String version) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createPermissionResource(viewName, version, null));
    }

    @GET
    @Path(value="{permissionId}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get single view permission", response=ViewPermissionResponse.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", defaultValue="PermissionInfo/*", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="Cluster not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid arguments")})
    public Response getPermission(@Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="view name") @PathParam(value="viewName") String viewName, @ApiParam(value="view version") @PathParam(value="version") String version, @ApiParam(value="permission id") @PathParam(value="permissionId") String permissionId) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createPermissionResource(viewName, version, permissionId));
    }

    @POST
    @Path(value="{permissionId}")
    @Produces(value={"text/plain"})
    public Response createPermission(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="view name") @PathParam(value="viewName") String viewName, @ApiParam(value="view version") @PathParam(value="version") String version, @ApiParam(value="permission id") @PathParam(value="permissionId") String permissionId) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createPermissionResource(viewName, version, permissionId));
    }

    @PUT
    @Path(value="{permissionId}")
    @Produces(value={"text/plain"})
    public Response updatePermission(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="view name") @PathParam(value="viewName") String viewName, @ApiParam(value="view version") @PathParam(value="version") String version, @ApiParam(value="permission id") @PathParam(value="permissionId") String permissionId) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createPermissionResource(viewName, version, permissionId));
    }

    @DELETE
    @Path(value="{permissionId}")
    @Produces(value={"text/plain"})
    public Response deletePermission(@Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="view name") @PathParam(value="viewName") String viewName, @ApiParam(value="view version") @PathParam(value="version") String version, @ApiParam(value="permission id") @PathParam(value="permissionId") String permissionId) {
        return this.handleRequest(headers, null, ui, Request.Type.DELETE, this.createPermissionResource(viewName, version, permissionId));
    }

    protected ResourceInstance createPermissionResource(String viewName, String viewVersion, String permissionId) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.View, viewName);
        mapIds.put(Resource.Type.ViewVersion, viewVersion);
        mapIds.put(Resource.Type.ViewPermission, permissionId);
        return this.createResource(Resource.Type.ViewPermission, mapIds);
    }
}

