/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services.views;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.ResultImpl;
import id.onyx.obdp.server.api.services.ResultStatus;
import id.onyx.obdp.server.api.services.serializers.JsonSerializer;
import id.onyx.obdp.server.controller.ViewInstanceResponse;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.orm.entities.ViewInstanceEntity;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import id.onyx.obdp.server.view.ViewRegistry;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;

@Path(value="/views/{viewName}/versions/{version}/instances")
@Api(tags={"Views"}, description="Endpoint for view specific operations")
public class ViewInstanceService
extends BaseService {
    public static final String VIEW_INSTANCE_REQUEST_TYPE = "id.onyx.obdp.server.controller.ViewInstanceResponse";
    private final ViewRegistry viewRegistry = ViewRegistry.getInstance();

    @GET
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get all view instances", response=ViewInstanceResponse.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", defaultValue="ViewInstanceInfo/*", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort resources in result by (asc | desc)", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive).  \"start\" is also accepted.", allowableValues="range[0, infinity]", defaultValue="0", dataType="integer", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive).  \"end\" is also accepted.", allowableValues="range[1, infinity]", dataType="integer", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="Cluster not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid arguments")})
    public Response getServices(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="viewName") String viewName, @PathParam(value="version") String version) throws AuthorizationException {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createResource(viewName, version, null));
    }

    @GET
    @Path(value="{instanceName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get single view instance", response=ViewInstanceResponse.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", defaultValue="ViewInstanceInfo/*", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="Cluster not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid arguments")})
    public Response getService(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="view name") @PathParam(value="viewName") String viewName, @PathParam(value="version") String version, @ApiParam(value="instance name") @PathParam(value="instanceName") String instanceName) throws AuthorizationException {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createResource(viewName, version, instanceName));
    }

    @POST
    @Path(value="{instanceName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Create view instance")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.ViewInstanceResponse", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=201, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=404, message="Cluster not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createService(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="view name") @PathParam(value="viewName") String viewName, @PathParam(value="version") String version, @ApiParam(value="instance name") @PathParam(value="instanceName") String instanceName) throws AuthorizationException {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createResource(viewName, version, instanceName));
    }

    @POST
    @Produces(value={"text/plain"})
    @ApiOperation(value="Create view instances")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.ViewInstanceResponse", paramType="body", allowMultiple=true)})
    @ApiResponses(value={@ApiResponse(code=201, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=404, message="Cluster not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createServices(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="viewName") String viewName, @PathParam(value="version") String version) throws AuthorizationException {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createResource(viewName, version, null));
    }

    @PUT
    @Path(value="{instanceName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Update view instance detail")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.ViewInstanceResponse", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=404, message="Cluster or host not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateService(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="view name") @PathParam(value="viewName") String viewName, @PathParam(value="version") String version, @ApiParam(value="instance name") @PathParam(value="instanceName") String instanceName) throws AuthorizationException {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createResource(viewName, version, instanceName));
    }

    @PUT
    @Produces(value={"text/plain"})
    @ApiOperation(value="Update multiple view instance detail")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.ViewInstanceResponse", paramType="body", allowMultiple=true)})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=404, message="Cluster or host not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateServices(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="viewName") String viewName, @PathParam(value="version") String version) throws AuthorizationException {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createResource(viewName, version, null));
    }

    @DELETE
    @Path(value="{instanceName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Delete view instance")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="Cluster or host not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteService(@Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="view name") @PathParam(value="viewName") String viewName, @PathParam(value="version") String version, @ApiParam(value="instance name") @PathParam(value="instanceName") String instanceName) throws AuthorizationException {
        return this.handleRequest(headers, null, ui, Request.Type.DELETE, this.createResource(viewName, version, instanceName));
    }

    @Path(value="{instanceName}/{resources}")
    public Object getResourceHandler(@Context Request request, @PathParam(value="viewName") String viewName, @PathParam(value="version") String version, @PathParam(value="instanceName") String instanceName, @PathParam(value="resources") String resources) {
        this.hasPermission(viewName, version, Request.Type.valueOf(request.getMethod()), instanceName);
        ViewInstanceEntity instanceDefinition = ViewRegistry.getInstance().getInstanceDefinition(viewName, version, instanceName);
        if (instanceDefinition == null) {
            String msg = "A view instance " + viewName + "/" + instanceName + " can not be found.";
            return new NotFoundResponse(msg);
        }
        Object service = instanceDefinition.getService(resources);
        if (service == null) {
            String msg = "A resource type " + resources + " for view instance " + viewName + "/" + instanceName + " can not be found.";
            return new NotFoundResponse(msg);
        }
        return service;
    }

    private ResourceInstance createResource(String viewName, String viewVersion, String instanceName) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.View, viewName);
        mapIds.put(Resource.Type.ViewVersion, viewVersion);
        mapIds.put(Resource.Type.ViewInstance, instanceName);
        return this.createResource(Resource.Type.ViewInstance, mapIds);
    }

    private void hasPermission(String viewName, String version, Request.Type requestType, String instanceName) {
        if (!this.viewRegistry.checkPermission(viewName, version, instanceName, requestType == Request.Type.GET)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }

    @Path(value="/")
    public class NotFoundResponse {
        String msg;

        NotFoundResponse(String msg) {
            this.msg = msg;
        }

        @GET
        @Produces(value={"text/plain"})
        @ApiOperation(value="Handle GET resource with 404 response")
        public Response get() {
            return this.getResponse();
        }

        @POST
        @Produces(value={"text/plain"})
        @ApiOperation(value="Handle POST resource with 404 response")
        public Response post() {
            return this.getResponse();
        }

        @PUT
        @Produces(value={"text/plain"})
        @ApiOperation(value="Handle PUT resource with 404 response")
        public Response put() {
            return this.getResponse();
        }

        @DELETE
        @Produces(value={"text/plain"})
        @ApiOperation(value="Handle DELETE resource with 404 response")
        public Response delete() {
            return this.getResponse();
        }

        @GET
        @Path(value="{path: .*}")
        @Produces(value={"text/plain"})
        @ApiOperation(value="Handle GET sub-resource with 404 response")
        public Response getSub() {
            return this.getResponse();
        }

        @POST
        @Path(value="{path: .*}")
        @Produces(value={"text/plain"})
        @ApiOperation(value="Handle POST sub-resource with 404 response")
        public Response postSub() {
            return this.getResponse();
        }

        @PUT
        @Path(value="{path: .*}")
        @Produces(value={"text/plain"})
        @ApiOperation(value="Handle PUT sub-resource with 404 response")
        public Response putSub() {
            return this.getResponse();
        }

        @DELETE
        @Path(value="{path: .*}")
        @Produces(value={"text/plain"})
        @ApiOperation(value="Handle DELETE sub-resource with 404 response")
        public Response deleteSub() {
            return this.getResponse();
        }

        public Response getResponse() {
            ResultImpl result = new ResultImpl(new ResultStatus(ResultStatus.STATUS.NOT_FOUND, this.msg));
            Response.ResponseBuilder builder = Response.status((int)result.getStatus().getStatusCode()).entity(new JsonSerializer().serialize(result));
            return builder.build();
        }
    }
}

