/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services.views;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.orm.entities.ViewEntity;
import id.onyx.obdp.server.orm.entities.ViewInstanceEntity;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ViewExternalSubResourceService
extends BaseService {
    private final Resource.Type type;
    private final String viewName;
    private final String version;
    private final String instanceName;
    private final Map<String, Object> resourceServiceMap = new HashMap<String, Object>();

    public ViewExternalSubResourceService(Resource.Type type, ViewInstanceEntity viewInstanceDefinition) {
        ViewEntity viewEntity = viewInstanceDefinition.getViewEntity();
        this.type = type;
        this.viewName = viewEntity.getCommonName();
        this.version = viewEntity.getVersion();
        this.instanceName = viewInstanceDefinition.getName();
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getResources(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createResource(this.viewName, this.instanceName));
    }

    @Path(value="{resourceName}")
    public Object getResource(@PathParam(value="resourceName") String resourceName) throws IOException {
        Object service = this.resourceServiceMap.get(resourceName);
        if (service == null) {
            throw new IllegalArgumentException("A resource type " + resourceName + " for view instance " + this.viewName + "/" + this.instanceName + " can not be found.");
        }
        return service;
    }

    public void addResourceService(String resourceName, Object service) {
        this.resourceServiceMap.put(resourceName, service);
    }

    private ResourceInstance createResource(String viewName, String instanceName) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.View, viewName);
        mapIds.put(Resource.Type.ViewVersion, this.version);
        mapIds.put(Resource.Type.ViewInstance, instanceName);
        return this.createResource(this.type, mapIds);
    }
}

