/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services.views;

import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.orm.entities.ViewInstanceEntity;
import id.onyx.obdp.server.view.ViewDataMigrationUtility;
import id.onyx.obdp.server.view.ViewRegistry;
import id.onyx.obdp.view.migration.ViewDataMigrationException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/views/{viewName}/versions/{version}/instances/{instanceName}/migrate")
@Api(tags={"Views"}, description="Endpoint for view specific operations")
public class ViewDataMigrationService
extends BaseService {
    private static final Logger LOG = LoggerFactory.getLogger(ViewDataMigrationService.class);
    private ViewRegistry viewRegistry = ViewRegistry.getInstance();
    private ViewDataMigrationUtility viewDataMigrationUtility;

    @PUT
    @Path(value="{originVersion}/{originInstanceName}")
    @ApiOperation(value="Migrate view instance data", notes="Migrates view instance persistence data from origin view instance specified in the path params.")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="Cluster not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid arguments")})
    public Response migrateData(@ApiParam(value="view name") @PathParam(value="viewName") String viewName, @ApiParam(value="view version") @PathParam(value="version") String viewVersion, @ApiParam(value="instance name") @PathParam(value="instanceName") String instanceName, @ApiParam(value="origin version") @PathParam(value="originVersion") String originViewVersion, @ApiParam(value="origin instance name") @PathParam(value="originInstanceName") String originInstanceName) throws ViewDataMigrationException {
        if (!this.viewRegistry.checkAdmin()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        LOG.info("Data Migration to view instance " + viewName + "/" + viewVersion + "/" + instanceName + " from " + viewName + "/" + originViewVersion + "/" + originInstanceName);
        ViewInstanceEntity instanceDefinition = this.viewRegistry.getInstanceDefinition(viewName, viewVersion, instanceName);
        ViewInstanceEntity originInstanceDefinition = this.viewRegistry.getInstanceDefinition(viewName, originViewVersion, originInstanceName);
        this.getViewDataMigrationUtility().migrateData(instanceDefinition, originInstanceDefinition, false);
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        return builder.build();
    }

    protected ViewDataMigrationUtility getViewDataMigrationUtility() {
        if (this.viewDataMigrationUtility == null) {
            this.viewDataMigrationUtility = new ViewDataMigrationUtility(this.viewRegistry);
        }
        return this.viewDataMigrationUtility;
    }

    protected void setViewDataMigrationUtility(ViewDataMigrationUtility viewDataMigrationUtility) {
        this.viewDataMigrationUtility = viewDataMigrationUtility;
    }
}

