/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services.users;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.UserResponse;
import id.onyx.obdp.server.controller.spi.Resource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collections;

@Path(value="/users/")
@Api(value="Users", description="Endpoint for user specific operations")
public class UserService
extends BaseService {
    private static final String UPDATE_USER_REQUEST_TYPE = "id.onyx.obdp.server.controller.UserRequestUpdateUserSwagger";
    private static final String CREATE_USER_REQUEST_TYPE = "id.onyx.obdp.server.controller.UserRequestCreateUserSwagger";
    private static final String CREATE_USERS_REQUEST_TYPE = "id.onyx.obdp.server.controller.UserRequestCreateUsersSwagger";
    private static final String USER_DEFAULT_SORT = "Users/user_name.asc";

    @GET
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get all users", response=UserResponse.UserResponseSwagger.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", dataType="string", paramType="query", defaultValue="Users/user_name"), @ApiImplicitParam(name="sortBy", value="Sort resources in result by (asc | desc)", dataType="string", paramType="query", defaultValue="Users/user_name.asc"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive).  \"start\" is also accepted.", allowableValues="range[0, infinity]", defaultValue="0", dataType="integer", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive).  \"end\" is also accepted.", allowableValues="range[1, infinity]", dataType="integer", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getUsers(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createUserResource(null));
    }

    @GET
    @Path(value="{userName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get single user", response=UserResponse.UserResponseSwagger.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", dataType="string", paramType="query", defaultValue="Users/*")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getUser(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="user name", required=true) @PathParam(value="userName") String userName) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createUserResource(userName));
    }

    @POST
    @Produces(value={"text/plain"})
    @ApiOperation(value="Creates one or more users in a single request")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.UserRequestCreateUsersSwagger", paramType="body", allowMultiple=true)})
    @ApiResponses(value={@ApiResponse(code=201, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=409, message="The requested resource already exists."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createUsers(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createUserResource(null));
    }

    @POST
    @Path(value="{userName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Create new user")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.UserRequestCreateUserSwagger", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=201, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=409, message="The requested resource already exists."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createUser(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="user name", required=true) @PathParam(value="userName") String userName) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createUserResource(userName));
    }

    @PUT
    @Path(value="{userName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Update user details")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.UserRequestUpdateUserSwagger", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=409, message="The requested resource already exists."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateUser(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="user name", required=true) @PathParam(value="userName") String userName) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createUserResource(userName));
    }

    @DELETE
    @Path(value="{userName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Delete single user")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=500, message="Server Error")})
    public Response deleteUser(@Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="user name", required=true) @PathParam(value="userName") String userName) {
        return this.handleRequest(headers, null, ui, Request.Type.DELETE, this.createUserResource(userName));
    }

    private ResourceInstance createUserResource(String userName) {
        return this.createResource(Resource.Type.User, Collections.singletonMap(Resource.Type.User, userName));
    }
}

