/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services.users;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.UserPrivilegeResponse;
import id.onyx.obdp.server.controller.spi.Resource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;

@Path(value="/users/{userName}/privileges")
@Api(value="Users", description="Endpoint for user specific operations")
public class UserPrivilegeService
extends BaseService {
    @GET
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get all privileges", nickname="UserPrivilegeService#getPrivileges", notes="Returns all privileges for user.", response=UserPrivilegeResponse.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter user privileges", defaultValue="PrivilegeInfo/*", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort user privileges (asc | desc)", defaultValue="PrivilegeInfo/user_name.asc", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive). Valid values are :offset | \"start\"", defaultValue="0", dataType="string", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive). Valid values are :offset | \"end\"", dataType="string", paramType="query")})
    public Response getPrivileges(@Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="user name", required=true, defaultValue="admin") @PathParam(value="userName") String userName) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createPrivilegeResource(userName, null));
    }

    @GET
    @Path(value="{privilegeId}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get user privilege", nickname="UserPrivilegeService#getPrivilege", notes="Returns user privilege details.", response=UserPrivilegeResponse.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter user privilege details", defaultValue="PrivilegeInfo/*", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=UserPrivilegeResponse.class)})
    public Response getPrivilege(@Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="user name", required=true) @PathParam(value="userName") String userName, @ApiParam(value="privilege id", required=true) @PathParam(value="privilegeId") String privilegeId) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createPrivilegeResource(userName, privilegeId));
    }

    protected ResourceInstance createPrivilegeResource(String userName, String privilegeId) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.User, StringUtils.lowerCase((String)userName));
        mapIds.put(Resource.Type.UserPrivilege, privilegeId);
        return this.createResource(Resource.Type.UserPrivilege, mapIds);
    }
}

