/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services.users;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.UserAuthorizationResponse;
import id.onyx.obdp.server.controller.spi.Resource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;

@Path(value="/users/{userName}/authorizations")
@Api(value="Users", description="Endpoint for user specific operations")
public class UserAuthorizationService
extends BaseService {
    @GET
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get all authorizations", nickname="UserAuthorizationService#getAuthorizations", notes="Returns all authorization for user.", response=UserAuthorizationResponse.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter user authorization details", defaultValue="AuthorizationInfo/*", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort user authorizations (asc | desc)", defaultValue="AuthorizationInfo/user_name.asc", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive). Valid values are :offset | \"start\"", defaultValue="0", dataType="string", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive). Valid values are :offset | \"end\"", dataType="string", paramType="query")})
    public Response getAuthorizations(@Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="user name", required=true) @PathParam(value="userName") String userName) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createAuthorizationResource(userName, null));
    }

    @GET
    @Path(value="{authorization_id}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get user authorization", nickname="UserAuthorizationService#getAuthorization", notes="Returns user authorization details.", response=UserAuthorizationResponse.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter user authorization details", defaultValue="AuthorizationInfo/*", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=UserAuthorizationResponse.class)})
    public Response getAuthorization(@Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="user name", required=true) @PathParam(value="userName") String userName, @ApiParam(value="Authorization Id", required=true) @PathParam(value="authorization_id") String authorizationId) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createAuthorizationResource(userName, authorizationId));
    }

    protected ResourceInstance createAuthorizationResource(String userName, String authorizationId) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.User, StringUtils.lowerCase((String)userName));
        mapIds.put(Resource.Type.UserAuthorization, authorizationId);
        return this.createResource(Resource.Type.UserAuthorization, mapIds);
    }
}

