/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services.users;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.UserAuthenticationSourceResponse;
import id.onyx.obdp.server.controller.spi.Resource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;

@Path(value="/users/{userName}/sources")
@Api(value="User Authentication Sources", description="Endpoint for user specific authentication source operations")
public class UserAuthenticationSourceService
extends BaseService {
    private static final String CREATE_REQUEST_TYPE = "id.onyx.obdp.server.controller.UserAuthenticationSourceRequestCreateSwagger";
    private static final String UPDATE_REQUEST_TYPE = "id.onyx.obdp.server.controller.UserAuthenticationSourceRequestUpdateSwagger";
    private static final String AUTHENTICATION_SOURCE_DEFAULT_SORT = "AuthenticationSourceInfo/source_id.asc";

    @GET
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get all authentication sources", response=UserAuthenticationSourceResponse.UserAuthenticationSourceResponseSwagger.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", dataType="string", paramType="query", defaultValue="AuthenticationSourceInfo/source_id,AuthenticationSourceInfo/user_name"), @ApiImplicitParam(name="sortBy", value="Sort resources in result by (asc | desc)", dataType="string", paramType="query", defaultValue="AuthenticationSourceInfo/source_id.asc"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive).  \"start\" is also accepted.", allowableValues="range[0, infinity]", defaultValue="0", dataType="integer", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive).  \"end\" is also accepted.", allowableValues="range[1, infinity]", dataType="integer", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getAuthenticationSources(@Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="user name", required=true) @PathParam(value="userName") String userName) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createResource(userName, null));
    }

    @GET
    @Path(value="{sourceId}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get user authentication source", response=UserAuthenticationSourceResponse.UserAuthenticationSourceResponseSwagger.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", dataType="string", paramType="query", defaultValue="AuthenticationSourceInfo/*")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getAuthenticationSource(@Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="user name", required=true) @PathParam(value="userName") String userName, @ApiParam(value="source id", required=true) @PathParam(value="sourceId") String sourceId) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createResource(userName, sourceId));
    }

    @POST
    @Produces(value={"text/plain"})
    @ApiOperation(value="Create one or more new authentication sources for a user")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.UserAuthenticationSourceRequestCreateSwagger", paramType="body", allowMultiple=true)})
    @ApiResponses(value={@ApiResponse(code=201, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=409, message="The requested resource already exists."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createAuthenticationSources(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="user name", required=true) @PathParam(value="userName") String userName) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createResource(userName, null));
    }

    @PUT
    @Path(value="{sourceId}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Updates an existing authentication source")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.UserAuthenticationSourceRequestUpdateSwagger", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=409, message="The requested resource already exists."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateAuthenticationSource(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="user name", required=true) @PathParam(value="userName") String userName, @ApiParam(value="source id", required=true) @PathParam(value="sourceId") String sourceId) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createResource(userName, sourceId));
    }

    @DELETE
    @Path(value="{sourceId}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Deletes an existing authentication source")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteAuthenticationSource(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="user name", required=true) @PathParam(value="userName") String userName, @ApiParam(value="source id", required=true) @PathParam(value="sourceId") String sourceId) {
        return this.handleRequest(headers, body, ui, Request.Type.DELETE, this.createResource(userName, sourceId));
    }

    protected ResourceInstance createResource(String userName, String sourceId) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.User, StringUtils.lowerCase((String)userName));
        mapIds.put(Resource.Type.UserAuthenticationSource, sourceId);
        return this.createResource(Resource.Type.UserAuthenticationSource, mapIds);
    }
}

