/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services.users;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.ActiveWidgetLayoutResponse;
import id.onyx.obdp.server.controller.spi.Resource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;

@Path(value="/users/{userName}/activeWidgetLayouts")
@Api(value="Users", description="Endpoint for User specific operations")
public class ActiveWidgetLayoutService
extends BaseService {
    @GET
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get user widget layouts", nickname="ActiveWidgetLayoutService#getServices", notes="Returns all active widget layouts for user.", response=ActiveWidgetLayoutResponse.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter user layout details", defaultValue="WidgetLayoutInfo/*", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort layouts (asc | desc)", defaultValue="WidgetLayoutInfo/user_name.asc", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive). Valid values are :offset | \"start\"", defaultValue="0", dataType="string", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive). Valid values are :offset | \"end\"", dataType="string", paramType="query")})
    public Response getServices(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="user name", required=true) @PathParam(value="userName") String userName) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createResource(userName));
    }

    @PUT
    @Produces(value={"text/plain"})
    @ApiOperation(value="Update user widget layouts", nickname="ActiveWidgetLayoutService#updateServices", notes="Updates user widget layout.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="input parameters in json form", required=true, dataType="id.onyx.obdp.server.controller.ActiveWidgetLayoutRequest", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=500, message="Server Error")})
    public Response updateServices(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="user name", required=true) @PathParam(value="userName") String userName) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createResource(userName));
    }

    private ResourceInstance createResource(String userName) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.User, StringUtils.lowerCase((String)userName));
        return this.createResource(Resource.Type.ActiveWidgetLayout, mapIds);
    }
}

