/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services.stackadvisor.recommendations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorResponse;
import id.onyx.obdp.server.state.ValueAttributesInfo;
import id.onyx.obdp.server.topology.ConfigurableHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class RecommendationResponse
extends StackAdvisorResponse {
    @JsonProperty
    private Set<String> hosts;
    @JsonProperty
    private Set<String> services;
    @JsonProperty
    private Recommendation recommendations;

    public Set<String> getHosts() {
        return this.hosts;
    }

    public void setHosts(Set<String> hosts) {
        this.hosts = hosts;
    }

    public Set<String> getServices() {
        return this.services;
    }

    public void setServices(Set<String> services) {
        this.services = services;
    }

    public Recommendation getRecommendations() {
        return this.recommendations;
    }

    public void setRecommendations(Recommendation recommendations) {
        this.recommendations = recommendations;
    }

    public static class Recommendation {
        @JsonProperty
        private Blueprint blueprint;
        @JsonProperty(value="blueprint_cluster_binding")
        private BlueprintClusterBinding blueprintClusterBinding;
        @JsonProperty(value="config-groups")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private Set<ConfigGroup> configGroups;

        public Blueprint getBlueprint() {
            return this.blueprint;
        }

        public void setBlueprint(Blueprint blueprint) {
            this.blueprint = blueprint;
        }

        public BlueprintClusterBinding getBlueprintClusterBinding() {
            return this.blueprintClusterBinding;
        }

        public void setBlueprintClusterBinding(BlueprintClusterBinding blueprintClusterBinding) {
            this.blueprintClusterBinding = blueprintClusterBinding;
        }

        public Set<ConfigGroup> getConfigGroups() {
            return this.configGroups;
        }

        public void setConfigGroups(Set<ConfigGroup> configGroups) {
            this.configGroups = configGroups;
        }
    }

    public static class ConfigGroup {
        @JsonProperty
        private List<String> hosts;
        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private Map<String, BlueprintConfigurations> configurations = new HashMap<String, BlueprintConfigurations>();
        @JsonProperty(value="dependent_configurations")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private Map<String, BlueprintConfigurations> dependentConfigurations = new HashMap<String, BlueprintConfigurations>();

        public List<String> getHosts() {
            return this.hosts;
        }

        public void setHosts(List<String> hosts) {
            this.hosts = hosts;
        }

        public Map<String, BlueprintConfigurations> getConfigurations() {
            return this.configurations;
        }

        public void setConfigurations(Map<String, BlueprintConfigurations> configurations) {
            this.configurations = configurations;
        }

        public Map<String, BlueprintConfigurations> getDependentConfigurations() {
            return this.dependentConfigurations;
        }

        public void setDependentConfigurations(Map<String, BlueprintConfigurations> dependentConfigurations) {
            this.dependentConfigurations = dependentConfigurations;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigGroup that = (ConfigGroup)o;
            return Objects.equals(this.hosts, that.hosts) && Objects.equals(this.configurations, that.configurations) && Objects.equals(this.dependentConfigurations, that.dependentConfigurations);
        }

        public int hashCode() {
            return Objects.hash(this.hosts, this.configurations, this.dependentConfigurations);
        }
    }

    public static class BindingHostGroup {
        @JsonProperty
        private String name;
        @JsonProperty
        private Set<Map<String, String>> hosts;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Set<Map<String, String>> getHosts() {
            return this.hosts;
        }

        public void setHosts(Set<Map<String, String>> hosts) {
            this.hosts = hosts;
        }

        @JsonIgnore
        public Set<String> getHostNames() {
            return this.hosts.stream().map(host -> (String)host.get("fqdn")).collect(Collectors.toSet());
        }

        public static BindingHostGroup create(String name, Set<String> hostNames) {
            BindingHostGroup hostGroup = new BindingHostGroup();
            hostGroup.setName(name);
            Set<Map<String, String>> hosts = hostNames.stream().map(hostName -> ImmutableMap.of((Object)"fqdn", (Object)hostName)).collect(Collectors.toSet());
            hostGroup.setHosts(hosts);
            return hostGroup;
        }
    }

    public static class BlueprintClusterBinding {
        @JsonProperty(value="host_groups")
        private Set<BindingHostGroup> hostGroups;

        public Set<BindingHostGroup> getHostGroups() {
            return this.hostGroups;
        }

        public void setHostGroups(Set<BindingHostGroup> hostGroups) {
            this.hostGroups = hostGroups;
        }

        @JsonIgnore
        public Map<String, Set<String>> getHostgroupHostMap() {
            return this.hostGroups.stream().collect(Collectors.toMap(BindingHostGroup::getName, BindingHostGroup::getHostNames));
        }

        public static BlueprintClusterBinding fromHostGroupHostMap(Map<String, Set<String>> hostGroupHosts) {
            Set<BindingHostGroup> hostGroups = hostGroupHosts.entrySet().stream().map(entry -> BindingHostGroup.create((String)entry.getKey(), (Set)entry.getValue())).collect(Collectors.toSet());
            BlueprintClusterBinding binding = new BlueprintClusterBinding();
            binding.setHostGroups(hostGroups);
            return binding;
        }
    }

    public static class HostGroup {
        @JsonProperty
        private String name;
        @JsonProperty
        private Set<Map<String, String>> components;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Set<Map<String, String>> getComponents() {
            return this.components;
        }

        public void setComponents(Set<Map<String, String>> components) {
            this.components = components;
        }

        @JsonIgnore
        public Set<String> getComponentNames() {
            return this.components.stream().map(comp -> (String)comp.get("name")).collect(Collectors.toSet());
        }

        public static Set<HostGroup> fromHostGroupComponents(Map<String, Set<String>> hostGroupComponents) {
            return hostGroupComponents.entrySet().stream().map(entry -> HostGroup.create((String)entry.getKey(), (Set)entry.getValue())).collect(Collectors.toSet());
        }

        public static HostGroup create(String name, Set<String> componentNames) {
            HostGroup group = new HostGroup();
            group.setName(name);
            Set<Map<String, String>> components = componentNames.stream().map(comp -> ImmutableMap.of((Object)"name", (Object)comp)).collect(Collectors.toSet());
            group.setComponents(components);
            return group;
        }
    }

    public static class BlueprintConfigurations {
        @JsonProperty
        private final Map<String, String> properties = new HashMap<String, String>();
        @JsonProperty(value="property_attributes")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private Map<String, ValueAttributesInfo> propertyAttributes = null;

        public static BlueprintConfigurations create(Map<String, String> properties, Map<String, Map<String, String>> attributes) {
            BlueprintConfigurations config = new BlueprintConfigurations();
            config.setProperties(properties);
            if (attributes != null) {
                Map<String, Map<String, String>> transformedAttributes = ConfigurableHelper.transformAttributesMap(attributes);
                ObjectMapper mapper = new ObjectMapper();
                config.setPropertyAttributes(new HashMap<String, ValueAttributesInfo>(Maps.transformValues(transformedAttributes, attr -> ValueAttributesInfo.fromMap(attr, Optional.of(mapper)))));
            }
            return config;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public void setProperties(Map<String, String> properties) {
            this.properties.clear();
            if (properties != null) {
                this.properties.putAll(properties);
            }
        }

        public Map<String, ValueAttributesInfo> getPropertyAttributes() {
            return this.propertyAttributes;
        }

        @JsonIgnore
        public Map<String, Map<String, String>> getPropertyAttributesAsMap() {
            ObjectMapper mapper = new ObjectMapper();
            return null == this.propertyAttributes ? null : ConfigurableHelper.transformAttributesMap(Maps.transformValues(this.propertyAttributes, vaInfo -> vaInfo.toMap(Optional.of(mapper))));
        }

        public void setPropertyAttributes(Map<String, ValueAttributesInfo> propertyAttributes) {
            this.propertyAttributes = propertyAttributes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BlueprintConfigurations that = (BlueprintConfigurations)o;
            return Objects.equals(this.properties, that.properties) && Objects.equals(this.propertyAttributes, that.propertyAttributes);
        }

        public int hashCode() {
            return Objects.hash(this.properties, this.propertyAttributes);
        }
    }

    public static class Blueprint {
        @JsonProperty
        private Map<String, BlueprintConfigurations> configurations;
        @JsonProperty(value="host_groups")
        private Set<HostGroup> hostGroups;

        public Map<String, BlueprintConfigurations> getConfigurations() {
            return this.configurations;
        }

        public void setConfigurations(Map<String, BlueprintConfigurations> configurations) {
            this.configurations = configurations;
        }

        public Set<HostGroup> getHostGroups() {
            return this.hostGroups;
        }

        public void setHostGroups(Set<HostGroup> hostGroups) {
            this.hostGroups = hostGroups;
        }

        public Map<String, Set<String>> getHostgroupComponentMap() {
            return this.hostGroups.stream().flatMap(hg -> hg.getComponentNames().stream().map(comp -> Pair.of((Object)hg.getName(), (Object)comp))).collect(Collectors.groupingBy(Pair::getKey, Collectors.mapping(Pair::getValue, Collectors.toSet())));
        }
    }
}

