/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services.stackadvisor.commands;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.LocalUriInfo;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorException;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorRequest;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorResponse;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorRunner;
import id.onyx.obdp.server.api.services.stackadvisor.commands.StackAdvisorCommandType;
import id.onyx.obdp.server.controller.RootComponent;
import id.onyx.obdp.server.controller.RootService;
import id.onyx.obdp.server.controller.internal.OBDPServerConfigurationHandler;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.server.utils.DateUtils;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StackAdvisorCommand<T extends StackAdvisorResponse>
extends BaseService {
    private Class<T> type = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    private static final Logger LOG = LoggerFactory.getLogger(StackAdvisorCommand.class);
    private static final String GET_HOSTS_INFO_URI = "/api/v1/hosts?fields=Hosts/*&Hosts/host_name.in(%s)";
    private static final String GET_SERVICES_INFO_URI = "/api/v1/stacks/%s/versions/%s/?fields=Versions/stack_name,Versions/stack_version,Versions/parent_stack_version,services/StackServices/service_name,services/StackServices/service_version,services/components/StackServiceComponents,services/components/dependencies/Dependencies/scope,services/components/dependencies/Dependencies/type,services/components/dependencies/Dependencies/conditions,services/components/auto_deploy,services/configurations/StackConfigurations/property_depends_on,services/configurations/dependencies/StackConfigurationDependency/dependency_name,services/configurations/dependencies/StackConfigurationDependency/dependency_type,services/configurations/StackConfigurations/type&services/StackServices/service_name.in(%s)";
    private static final String SERVICES_PROPERTY = "services";
    private static final String SERVICES_COMPONENTS_PROPERTY = "components";
    private static final String CONFIG_GROUPS_PROPERTY = "config-groups";
    private static final String STACK_SERVICES_PROPERTY = "StackServices";
    private static final String COMPONENT_INFO_PROPERTY = "StackServiceComponents";
    private static final String COMPONENT_NAME_PROPERTY = "component_name";
    private static final String COMPONENT_HOSTNAMES_PROPERTY = "hostnames";
    private static final String CONFIGURATIONS_PROPERTY = "configurations";
    private static final String CHANGED_CONFIGURATIONS_PROPERTY = "changed-configurations";
    private static final String USER_CONTEXT_PROPERTY = "user-context";
    private static final String GPL_LICENSE_ACCEPTED = "gpl-license-accepted";
    private static final String AMBARI_SERVER_PROPERTIES_PROPERTY = "obdp-server-properties";
    private static final String AMBARI_SERVER_CONFIGURATIONS_PROPERTY = "obdp-server-configuration";
    private final Map<String, JsonNode> hostInfoCache;
    private File recommendationsDir;
    private String recommendationsArtifactsLifetime;
    private ServiceInfo.ServiceAdvisorType serviceAdvisorType;
    private int requestId;
    private File requestDirectory;
    private StackAdvisorRunner saRunner;
    protected ObjectMapper mapper = new ObjectMapper();
    private final OBDPMetaInfo metaInfo;
    private final OBDPServerConfigurationHandler ambariServerConfigurationHandler;

    public StackAdvisorCommand(File recommendationsDir, String recommendationsArtifactsLifetime, ServiceInfo.ServiceAdvisorType serviceAdvisorType, int requestId, StackAdvisorRunner saRunner, OBDPMetaInfo metaInfo, OBDPServerConfigurationHandler ambariServerConfigurationHandler, Map<String, JsonNode> hostInfoCache) {
        this.mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        this.recommendationsDir = recommendationsDir;
        this.recommendationsArtifactsLifetime = recommendationsArtifactsLifetime;
        this.serviceAdvisorType = serviceAdvisorType;
        this.requestId = requestId;
        this.saRunner = saRunner;
        this.metaInfo = metaInfo;
        this.ambariServerConfigurationHandler = ambariServerConfigurationHandler;
        this.hostInfoCache = hostInfoCache;
    }

    public StackAdvisorCommand(File recommendationsDir, String recommendationsArtifactsLifetime, ServiceInfo.ServiceAdvisorType serviceAdvisorType, int requestId, StackAdvisorRunner saRunner, OBDPMetaInfo metaInfo, OBDPServerConfigurationHandler ambariServerConfigurationHandler) {
        this(recommendationsDir, recommendationsArtifactsLifetime, serviceAdvisorType, requestId, saRunner, metaInfo, ambariServerConfigurationHandler, null);
    }

    protected abstract StackAdvisorCommandType getCommandType();

    protected abstract String getResultFileName();

    protected abstract void validate(StackAdvisorRequest var1) throws StackAdvisorException;

    protected StackAdvisorData adjust(StackAdvisorData data, StackAdvisorRequest request) {
        try {
            ObjectNode root = (ObjectNode)this.mapper.readTree(data.servicesJSON);
            this.populateStackHierarchy(root);
            this.populateComponentHostsMap(root, request.getComponentHostsMap());
            this.populateServiceAdvisors(root);
            this.populateConfigurations(root, request);
            this.populateConfigGroups(root, request);
            this.populateAmbariServerInfo(root);
            this.populateAmbariConfiguration(root);
            data.servicesJSON = this.mapper.writeValueAsString((Object)root);
        }
        catch (Exception e) {
            String message = "Error parsing services.json file content: " + e.getMessage();
            LOG.warn(message, (Throwable)e);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).build());
        }
        return data;
    }

    void populateAmbariConfiguration(ObjectNode root) {
        root.put(AMBARI_SERVER_CONFIGURATIONS_PROPERTY, this.mapper.valueToTree(this.ambariServerConfigurationHandler.getConfigurations()));
    }

    protected void populateAmbariServerInfo(ObjectNode root) {
        Map<String, String> serverProperties = this.metaInfo.getAmbariServerProperties();
        if (serverProperties != null && !serverProperties.isEmpty()) {
            JsonNode serverPropertiesNode = (JsonNode)this.mapper.convertValue(serverProperties, JsonNode.class);
            root.put(AMBARI_SERVER_PROPERTIES_PROPERTY, serverPropertiesNode);
        }
    }

    private void populateConfigurations(ObjectNode root, StackAdvisorRequest request) {
        Map<String, Map<String, Map<String, String>>> configurations = request.getConfigurations();
        ObjectNode configurationsNode = root.putObject(CONFIGURATIONS_PROPERTY);
        for (String siteName : configurations.keySet()) {
            ObjectNode siteNode = configurationsNode.putObject(siteName);
            Map<String, Map<String, String>> siteMap = configurations.get(siteName);
            for (String properties : siteMap.keySet()) {
                ObjectNode propertiesNode = siteNode.putObject(properties);
                Map<String, String> propertiesMap = siteMap.get(properties);
                for (String propertyName : propertiesMap.keySet()) {
                    String propertyValue = propertiesMap.get(propertyName);
                    propertiesNode.put(propertyName, propertyValue);
                }
            }
        }
        JsonNode changedConfigs = this.mapper.valueToTree(request.getChangedConfigurations());
        root.put(CHANGED_CONFIGURATIONS_PROPERTY, changedConfigs);
        JsonNode userContext = this.mapper.valueToTree(request.getUserContext());
        root.put(USER_CONTEXT_PROPERTY, userContext);
        root.put(GPL_LICENSE_ACCEPTED, request.getGplLicenseAccepted());
    }

    private void populateConfigGroups(ObjectNode root, StackAdvisorRequest request) {
        if (request.getConfigGroups() != null && !request.getConfigGroups().isEmpty()) {
            JsonNode configGroups = this.mapper.valueToTree(request.getConfigGroups());
            root.put(CONFIG_GROUPS_PROPERTY, configGroups);
        }
    }

    protected void populateStackHierarchy(ObjectNode root) {
        ObjectNode version = (ObjectNode)root.get("Versions");
        TextNode stackName = (TextNode)version.get("stack_name");
        TextNode stackVersion = (TextNode)version.get("stack_version");
        ObjectNode stackHierarchy = version.putObject("stack_hierarchy");
        stackHierarchy.put("stack_name", (JsonNode)stackName);
        ArrayNode parents = stackHierarchy.putArray("stack_versions");
        for (String parentVersion : this.metaInfo.getStackParentVersions(stackName.asText(), stackVersion.asText())) {
            parents.add(parentVersion);
        }
    }

    private void populateComponentHostsMap(ObjectNode root, Map<String, Set<String>> componentHostsMap) {
        ArrayNode services = (ArrayNode)root.get(SERVICES_PROPERTY);
        Iterator servicesIter = services.elements();
        while (servicesIter.hasNext()) {
            JsonNode service = (JsonNode)servicesIter.next();
            ArrayNode components = (ArrayNode)service.get(SERVICES_COMPONENTS_PROPERTY);
            Iterator componentsIter = components.elements();
            while (componentsIter.hasNext()) {
                JsonNode component = (JsonNode)componentsIter.next();
                ObjectNode componentInfo = (ObjectNode)component.get(COMPONENT_INFO_PROPERTY);
                String componentName = componentInfo.get(COMPONENT_NAME_PROPERTY).asText();
                Set<String> componentHosts = componentHostsMap.get(componentName);
                ArrayNode hostnames = componentInfo.putArray(COMPONENT_HOSTNAMES_PROPERTY);
                if (null == componentHosts) continue;
                for (String hostName : componentHosts) {
                    hostnames.add(hostName);
                }
            }
        }
    }

    private void populateServiceAdvisors(ObjectNode root) {
        ArrayNode services = (ArrayNode)root.get(SERVICES_PROPERTY);
        Iterator servicesIter = services.elements();
        ObjectNode version = (ObjectNode)root.get("Versions");
        String stackName = version.get("stack_name").asText();
        String stackVersion = version.get("stack_version").asText();
        while (servicesIter.hasNext()) {
            JsonNode service = (JsonNode)servicesIter.next();
            ObjectNode serviceVersion = (ObjectNode)service.get(STACK_SERVICES_PROPERTY);
            String serviceName = serviceVersion.get("service_name").asText();
            try {
                ServiceInfo serviceInfo = this.metaInfo.getService(stackName, stackVersion, serviceName);
                if (serviceInfo.getAdvisorFile() == null) continue;
                serviceVersion.put("advisor_name", serviceInfo.getAdvisorName());
                serviceVersion.put("advisor_path", serviceInfo.getAdvisorFile().getAbsolutePath());
            }
            catch (Exception e) {
                LOG.error("Error adding service advisor information to services.json", (Throwable)e);
            }
        }
    }

    public synchronized T invoke(StackAdvisorRequest request, ServiceInfo.ServiceAdvisorType serviceAdvisorType) throws StackAdvisorException {
        this.validate(request);
        String hostsJSON = this.getHostsInformation(request);
        String servicesJSON = this.getServicesInformation(request);
        StackAdvisorData adjusted = this.adjust(new StackAdvisorData(hostsJSON, servicesJSON), request);
        try {
            this.createRequestDirectory();
            FileUtils.writeStringToFile((File)new File(this.requestDirectory, "hosts.json"), (String)adjusted.hostsJSON, (Charset)Charset.defaultCharset());
            FileUtils.writeStringToFile((File)new File(this.requestDirectory, "services.json"), (String)adjusted.servicesJSON, (Charset)Charset.defaultCharset());
            this.saRunner.runScript(serviceAdvisorType, this.getCommandType(), this.requestDirectory);
            String result = FileUtils.readFileToString((File)new File(this.requestDirectory, this.getResultFileName()), (Charset)Charset.defaultCharset());
            StackAdvisorResponse response = (StackAdvisorResponse)this.mapper.readValue(result, this.type);
            return (T)this.updateResponse(request, this.setRequestId(response));
        }
        catch (StackAdvisorException ex) {
            throw ex;
        }
        catch (Exception e) {
            String message = "Error occured during stack advisor command invocation: ";
            LOG.warn(message, (Throwable)e);
            throw new StackAdvisorException(message + e.getMessage());
        }
    }

    protected abstract T updateResponse(StackAdvisorRequest var1, T var2);

    private T setRequestId(T response) {
        ((StackAdvisorResponse)response).setId(this.requestId);
        return response;
    }

    private void createRequestDirectory() throws IOException {
        if (!this.recommendationsDir.exists() && !this.recommendationsDir.mkdirs()) {
            throw new IOException("Cannot create " + this.recommendationsDir);
        }
        this.cleanupRequestDirectory();
        this.requestDirectory = new File(this.recommendationsDir, Integer.toString(this.requestId));
        if (this.requestDirectory.exists()) {
            FileUtils.deleteDirectory((File)this.requestDirectory);
        }
        if (!this.requestDirectory.mkdirs()) {
            throw new IOException("Cannot create " + this.requestDirectory);
        }
    }

    private void cleanupRequestDirectory() throws IOException {
        final Date cutoffDate = DateUtils.getDateSpecifiedTimeAgo(this.recommendationsArtifactsLifetime);
        Object[] oldDirectories = this.recommendationsDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File current, String name) {
                File file = new File(current, name);
                return file.isDirectory() && !FileUtils.isFileNewer((File)file, (Date)cutoffDate);
            }
        });
        if (oldDirectories.length > 0) {
            LOG.info(String.format("Deleting old directories %s from %s", StringUtils.join((Object[])oldDirectories, (String)", "), this.recommendationsDir));
        }
        for (Object oldDirectory : oldDirectories) {
            FileUtils.deleteQuietly((File)new File(this.recommendationsDir, (String)oldDirectory));
        }
    }

    String getHostsInformation(StackAdvisorRequest request) throws StackAdvisorException {
        Collection<String> unregistered;
        ArrayList<String> hostNames = new ArrayList<String>(request.getHosts());
        ArrayList<JsonNode> resultInfos = new ArrayList<JsonNode>();
        if (this.hostInfoCache != null && !this.hostInfoCache.isEmpty()) {
            Iterator hostNamesIterator = hostNames.iterator();
            while (hostNamesIterator.hasNext()) {
                String hostName = (String)hostNamesIterator.next();
                JsonNode node = this.hostInfoCache.get(hostName);
                if (node == null) continue;
                resultInfos.add(node);
                hostNamesIterator.remove();
            }
        }
        String hostsJSON = null;
        if (!hostNames.isEmpty()) {
            LOG.info(String.format("Fire host info request for hosts: " + ((Object)hostNames).toString(), new Object[0]));
            String hostsURI = String.format(GET_HOSTS_INFO_URI, String.join((CharSequence)",", hostNames));
            Response response = this.handleRequest(null, null, new LocalUriInfo(hostsURI), Request.Type.GET, this.createHostResource());
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                String message = String.format("Error occured during hosts information retrieving, status=%s, response=%s", response.getStatus(), (String)response.getEntity());
                LOG.warn(message);
                throw new StackAdvisorException(message);
            }
            hostsJSON = (String)response.getEntity();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Hosts information: {}", (Object)hostsJSON);
            }
        }
        if (this.hostInfoCache != null) {
            if (hostsJSON != null && !hostsJSON.isEmpty()) {
                try {
                    JsonNode root = this.mapper.readTree(hostsJSON);
                    Iterator iterator = root.get("items").elements();
                    while (iterator.hasNext()) {
                        JsonNode next = (JsonNode)iterator.next();
                        String hostName = next.get("Hosts").get("host_name").asText();
                        this.hostInfoCache.put(hostName, next);
                        resultInfos.add(next);
                    }
                }
                catch (IOException e) {
                    throw new StackAdvisorException("Error occured during parsing result host infos", e);
                }
            }
            String fullHostsURI = String.format(GET_HOSTS_INFO_URI, request.getHostsCommaSeparated());
            JsonNodeFactory f = JsonNodeFactory.instance;
            ObjectNode resultRoot = f.objectNode();
            resultRoot.put("href", fullHostsURI);
            ArrayNode resultArray = resultRoot.putArray("items");
            resultArray.addAll(resultInfos);
            hostsJSON = resultRoot.toString();
        }
        if ((unregistered = this.getUnregisteredHosts(hostsJSON, request.getHosts())).size() > 0) {
            String message = String.format("There are unregistered hosts in the request, %s", Arrays.toString(unregistered.toArray()));
            LOG.warn(message);
            throw new StackAdvisorException(message);
        }
        return hostsJSON;
    }

    private Collection<String> getUnregisteredHosts(String hostsJSON, List<String> hosts) throws StackAdvisorException {
        ArrayList<String> registeredHosts = new ArrayList<String>();
        try {
            JsonNode root = this.mapper.readTree(hostsJSON);
            Iterator iterator = root.get("items").elements();
            while (iterator.hasNext()) {
                JsonNode next = (JsonNode)iterator.next();
                String hostName = next.get("Hosts").get("host_name").asText();
                registeredHosts.add(hostName);
            }
            return CollectionUtils.subtract(hosts, registeredHosts);
        }
        catch (Exception e) {
            throw new StackAdvisorException("Error occured during calculating unregistered hosts", e);
        }
    }

    String getServicesInformation(StackAdvisorRequest request) throws StackAdvisorException {
        String stackName = request.getStackName();
        String stackVersion = request.getStackVersion();
        String servicesURI = String.format(GET_SERVICES_INFO_URI, stackName, stackVersion, request.getServicesCommaSeparated());
        Response response = this.handleRequest(null, null, new LocalUriInfo(servicesURI), Request.Type.GET, this.createStackVersionResource(stackName, stackVersion));
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            String message = String.format("Error occured during services information retrieving, status=%s, response=%s", response.getStatus(), (String)response.getEntity());
            LOG.warn(message);
            throw new StackAdvisorException(message);
        }
        String servicesJSON = (String)response.getEntity();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Services information: {}", (Object)servicesJSON);
        }
        return servicesJSON;
    }

    private ResourceInstance createHostResource() {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        return this.createResource(Resource.Type.Host, mapIds);
    }

    private ResourceInstance createConfigResource() {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.RootService, RootService.OBDP.name());
        mapIds.put(Resource.Type.RootServiceComponent, RootComponent.OBDP_SERVER.name());
        return this.createResource(Resource.Type.RootServiceComponentConfiguration, mapIds);
    }

    private ResourceInstance createStackVersionResource(String stackName, String stackVersion) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Stack, stackName);
        mapIds.put(Resource.Type.StackVersion, stackVersion);
        return this.createResource(Resource.Type.StackVersion, mapIds);
    }

    public static class StackAdvisorData {
        protected String hostsJSON;
        protected String servicesJSON;

        public StackAdvisorData(String hostsJSON, String servicesJSON) {
            this.hostsJSON = hostsJSON;
            this.servicesJSON = servicesJSON;
        }
    }
}

