/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services.stackadvisor.commands;

import com.fasterxml.jackson.databind.JsonNode;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorException;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorRequest;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorRunner;
import id.onyx.obdp.server.api.services.stackadvisor.commands.StackAdvisorCommand;
import id.onyx.obdp.server.api.services.stackadvisor.commands.StackAdvisorCommandType;
import id.onyx.obdp.server.api.services.stackadvisor.recommendations.RecommendationResponse;
import id.onyx.obdp.server.controller.internal.OBDPServerConfigurationHandler;
import id.onyx.obdp.server.state.ServiceInfo;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;

public class ConfigurationRecommendationCommand
extends StackAdvisorCommand<RecommendationResponse> {
    private final StackAdvisorCommandType commandType;

    public ConfigurationRecommendationCommand(StackAdvisorCommandType commandType, File recommendationsDir, String recommendationsArtifactsLifetime, ServiceInfo.ServiceAdvisorType serviceAdvisorType, int requestId, StackAdvisorRunner saRunner, OBDPMetaInfo metaInfo, OBDPServerConfigurationHandler ambariServerConfigurationHandler, Map<String, JsonNode> hostInfoCache) {
        super(recommendationsDir, recommendationsArtifactsLifetime, serviceAdvisorType, requestId, saRunner, metaInfo, ambariServerConfigurationHandler, hostInfoCache);
        this.commandType = commandType;
    }

    @Override
    public StackAdvisorCommandType getCommandType() {
        return this.commandType;
    }

    @Override
    protected void validate(StackAdvisorRequest request) throws StackAdvisorException {
        if (CollectionUtils.isEmpty(request.getHosts()) || CollectionUtils.isEmpty(request.getServices())) {
            throw new StackAdvisorException("Hosts and services must not be empty");
        }
    }

    @Override
    protected RecommendationResponse updateResponse(StackAdvisorRequest request, RecommendationResponse response) {
        response.getRecommendations().getBlueprint().setHostGroups(this.processHostGroups(request));
        response.getRecommendations().getBlueprintClusterBinding().setHostGroups(this.processHostGroupBindings(request));
        return response;
    }

    protected Set<RecommendationResponse.HostGroup> processHostGroups(StackAdvisorRequest request) {
        HashSet<RecommendationResponse.HostGroup> resultSet = new HashSet<RecommendationResponse.HostGroup>();
        for (Map.Entry<String, Set<String>> componentHost : request.getHostComponents().entrySet()) {
            String hostGroupName = componentHost.getKey();
            Set<String> components = componentHost.getValue();
            if (hostGroupName == null || components == null) continue;
            RecommendationResponse.HostGroup hostGroup = new RecommendationResponse.HostGroup();
            HashSet<Map<String, String>> componentsSet = new HashSet<Map<String, String>>();
            for (String component : components) {
                HashMap<String, String> componentMap = new HashMap<String, String>();
                componentMap.put("name", component);
                componentsSet.add(componentMap);
            }
            hostGroup.setComponents(componentsSet);
            hostGroup.setName(hostGroupName);
            resultSet.add(hostGroup);
        }
        return resultSet;
    }

    private Set<RecommendationResponse.BindingHostGroup> processHostGroupBindings(StackAdvisorRequest request) {
        HashSet<RecommendationResponse.BindingHostGroup> resultSet = new HashSet<RecommendationResponse.BindingHostGroup>();
        for (Map.Entry<String, Set<String>> hostBinding : request.getHostGroupBindings().entrySet()) {
            String hostGroupName = hostBinding.getKey();
            Set<String> hosts = hostBinding.getValue();
            if (hostGroupName == null || hosts == null) continue;
            RecommendationResponse.BindingHostGroup bindingHostGroup = new RecommendationResponse.BindingHostGroup();
            HashSet<Map<String, String>> hostsSet = new HashSet<Map<String, String>>();
            for (String host : hosts) {
                HashMap<String, String> hostMap = new HashMap<String, String>();
                hostMap.put("name", host);
                hostsSet.add(hostMap);
            }
            bindingHostGroup.setHosts(hostsSet);
            bindingHostGroup.setName(hostGroupName);
            resultSet.add(bindingHostGroup);
        }
        return resultSet;
    }

    @Override
    protected String getResultFileName() {
        return "configurations.json";
    }
}

