/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services.stackadvisor;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorException;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorRequestException;
import id.onyx.obdp.server.api.services.stackadvisor.commands.StackAdvisorCommandType;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.serviceadvisor.ServiceAdvisor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class StackAdvisorRunner {
    private static final Logger LOG = LoggerFactory.getLogger(StackAdvisorRunner.class);
    @Inject
    private Configuration configs;

    public void runScript(ServiceInfo.ServiceAdvisorType serviceAdvisorType, StackAdvisorCommandType saCommandType, File actionDirectory) throws StackAdvisorException {
        LOG.info(String.format("StackAdvisorRunner. serviceAdvisorType=%s, actionDirectory=%s, command=%s", new Object[]{serviceAdvisorType.toString(), actionDirectory, saCommandType}));
        String outputFile = actionDirectory + File.separator + "stackadvisor.out";
        String errorFile = actionDirectory + File.separator + "stackadvisor.err";
        String hostsFile = actionDirectory + File.separator + "hosts.json";
        String servicesFile = actionDirectory + File.separator + "services.json";
        LOG.info("StackAdvisorRunner. Expected files: hosts.json={}, services.json={}, output={}, error={}", new Object[]{hostsFile, servicesFile, outputFile, errorFile});
        int stackAdvisorReturnCode = -1;
        switch (serviceAdvisorType) {
            case JAVA: {
                LOG.info("StackAdvisorRunner.runScript(): Calling Java ServiceAdvisor's run method.");
                stackAdvisorReturnCode = ServiceAdvisor.run((String)saCommandType.toString(), (String)hostsFile, (String)servicesFile, (String)outputFile, (String)errorFile);
                LOG.info(String.format("StackAdvisorRunner.runScript(): Java ServiceAdvisor's return code: %d", stackAdvisorReturnCode));
                break;
            }
            case PYTHON: {
                LOG.info("StackAdvisorRunner.runScript(): Calling Python Stack Advisor.");
                ProcessBuilder builder = this.prepareShellCommand(ServiceInfo.ServiceAdvisorType.PYTHON, this.configs.getStackAdvisorScript(), saCommandType, actionDirectory, outputFile, errorFile);
                builder.environment().put("METADATA_DIR_PATH", this.configs.getProperty(Configuration.METADATA_DIR_PATH));
                builder.environment().put("BASE_SERVICE_ADVISOR", Paths.get(this.configs.getProperty(Configuration.METADATA_DIR_PATH), "service_advisor.py").toString());
                builder.environment().put("BASE_STACK_ADVISOR", Paths.get(this.configs.getProperty(Configuration.METADATA_DIR_PATH), "stack_advisor.py").toString());
                stackAdvisorReturnCode = this.launchProcess(builder);
            }
        }
        this.processLogs(stackAdvisorReturnCode, outputFile, errorFile);
    }

    private int launchProcess(ProcessBuilder builder) throws StackAdvisorException {
        int exitCode = -1;
        Process process = null;
        try {
            process = builder.start();
            exitCode = process.waitFor();
        }
        catch (Exception ioe) {
            String message = "Error executing Stack Advisor: ";
            LOG.error(message, (Throwable)ioe);
            throw new StackAdvisorException(message + ioe.getMessage());
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return exitCode;
    }

    private void processLogs(int exitCode, String outputFile, String errorFile) throws StackAdvisorException {
        this.printMessage("stdout", outputFile);
        String errMessage = this.printMessage("stderr", errorFile);
        if (exitCode != 0) {
            Object errorMessage;
            if (errMessage != null) {
                int index = errMessage.lastIndexOf("\n");
                if (index > 0 && index == errMessage.length() - 1) {
                    index = errMessage.lastIndexOf("\n", index - 1);
                }
                if (index > -1) {
                    errMessage = errMessage.substring(index + 1).trim();
                }
                errorMessage = String.format("Stack Advisor reported an error. Exit Code: %s. Error: %s ", exitCode, errMessage);
            } else {
                errorMessage = String.format("Error occurred during Stack Advisor execution. Exit Code: %s", exitCode);
            }
            errorMessage = (String)errorMessage + "\nStdOut file: " + outputFile + "\n";
            errorMessage = (String)errorMessage + "\nStdErr file: " + errorFile;
            switch (exitCode) {
                case 1: {
                    throw new StackAdvisorRequestException((String)errorMessage);
                }
                case 2: {
                    throw new StackAdvisorException((String)errorMessage);
                }
            }
        }
    }

    private String printMessage(String type, String file) {
        String message = null;
        try {
            message = FileUtils.readFileToString((File)new File(file), (Charset)Charset.defaultCharset()).trim();
            LOG.info("    Advisor script {}: {}", (Object)type, (Object)message);
        }
        catch (IOException io) {
            LOG.error("Error in reading script log files", (Throwable)io);
        }
        return message;
    }

    ProcessBuilder prepareShellCommand(ServiceInfo.ServiceAdvisorType serviceAdvisorType, String script, StackAdvisorCommandType saCommandType, File actionDirectory, String outputFile, String errorFile) {
        String hostsFile = actionDirectory + File.separator + "hosts.json";
        String servicesFile = actionDirectory + File.separator + "services.json";
        ArrayList<String> builderParameters = new ArrayList<String>();
        switch (serviceAdvisorType) {
            case JAVA: 
            case PYTHON: {
                if (System.getProperty("os.name").contains("Windows")) {
                    builderParameters.add("cmd");
                    builderParameters.add("/c");
                    break;
                }
                builderParameters.add("sh");
                builderParameters.add("-c");
                break;
            }
        }
        String[] commandStringParameters = new String[]{script, saCommandType.toString(), hostsFile, servicesFile, "1>", outputFile, "2>", errorFile};
        StringBuilder commandString = new StringBuilder();
        for (String command : commandStringParameters) {
            commandString.append(command).append(" ");
        }
        builderParameters.add(commandString.toString());
        LOG.debug("StackAdvisorRunner. Stack advisor command is {}", (Object)StringUtils.join((Object[])new Object[]{" ", builderParameters}));
        return new ProcessBuilder(builderParameters);
    }

    public void setConfigs(Configuration configs) {
        this.configs = configs;
    }
}

