/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services.stackadvisor;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorException;
import id.onyx.obdp.server.api.services.stackadvisor.recommendations.RecommendationResponse;
import id.onyx.obdp.server.state.ChangedConfigInfo;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.topology.Configuration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class StackAdvisorRequest {
    private Long clusterId;
    private String serviceName;
    private String stackName;
    private String stackVersion;
    private StackAdvisorRequestType requestType;
    private List<String> hosts = new ArrayList<String>();
    private Collection<String> services = new ArrayList<String>();
    private Map<String, Set<String>> componentHostsMap = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> hostComponents = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> hostGroupBindings = new HashMap<String, Set<String>>();
    private Map<String, Map<String, Map<String, String>>> configurations = new HashMap<String, Map<String, Map<String, String>>>();
    private List<ChangedConfigInfo> changedConfigurations = new LinkedList<ChangedConfigInfo>();
    private Set<RecommendationResponse.ConfigGroup> configGroups;
    private Map<String, String> userContext = new HashMap<String, String>();
    private Map<String, Object> ldapConfig = new HashMap<String, Object>();
    private Boolean gplLicenseAccepted;
    private Boolean configsResponse = false;

    public String getStackName() {
        return this.stackName;
    }

    public String getStackVersion() {
        return this.stackVersion;
    }

    public StackAdvisorRequestType getRequestType() {
        return this.requestType;
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public Collection<String> getServices() {
        return this.services;
    }

    public Map<String, Set<String>> getComponentHostsMap() {
        return this.componentHostsMap;
    }

    public String getHostsCommaSeparated() {
        return StringUtils.join(this.hosts, (String)",");
    }

    public String getServicesCommaSeparated() {
        return StringUtils.join(this.services, (String)",");
    }

    public Map<String, Set<String>> getHostComponents() {
        return this.hostComponents;
    }

    public Map<String, Set<String>> getHostGroupBindings() {
        return this.hostGroupBindings;
    }

    public Map<String, Map<String, Map<String, String>>> getConfigurations() {
        return this.configurations;
    }

    public Map<String, Object> getLdapConfig() {
        return this.ldapConfig;
    }

    public List<ChangedConfigInfo> getChangedConfigurations() {
        return this.changedConfigurations;
    }

    public void setChangedConfigurations(List<ChangedConfigInfo> changedConfigurations) {
        this.changedConfigurations = changedConfigurations;
    }

    public Map<String, String> getUserContext() {
        return this.userContext;
    }

    public void setUserContext(Map<String, String> userContext) {
        this.userContext = userContext;
    }

    public Set<RecommendationResponse.ConfigGroup> getConfigGroups() {
        return this.configGroups;
    }

    public void setConfigGroups(Set<RecommendationResponse.ConfigGroup> configGroups) {
        this.configGroups = configGroups;
    }

    public Long getClusterId() {
        return this.clusterId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Boolean getGplLicenseAccepted() {
        return this.gplLicenseAccepted;
    }

    public Boolean getConfigsResponse() {
        return this.configsResponse;
    }

    private StackAdvisorRequest(String stackName, String stackVersion) {
        this.stackName = stackName;
        this.stackVersion = stackVersion;
    }

    public StackAdvisorRequestBuilder builder() {
        return StackAdvisorRequestBuilder.forStack(this.stackName, this.stackVersion).ofType(this.requestType).forHosts(this.hosts).forServices(this.services).forHostComponents(this.hostComponents).forHostsGroupBindings(this.hostGroupBindings).withComponentHostsMap(this.componentHostsMap).withConfigurations(this.configurations).withChangedConfigurations(this.changedConfigurations).withConfigGroups(this.configGroups).withUserContext(this.userContext).withGPLLicenseAccepted(this.gplLicenseAccepted).withLdapConfig(this.ldapConfig);
    }

    public static enum StackAdvisorRequestType {
        HOST_GROUPS("host_groups"),
        CONFIGURATIONS("configurations"),
        LDAP_CONFIGURATIONS("ldap-configurations"),
        SSO_CONFIGURATIONS("sso-configurations"),
        KERBEROS_CONFIGURATIONS("kerberos-configurations"),
        CONFIGURATION_DEPENDENCIES("configuration-dependencies");

        private String type;

        private StackAdvisorRequestType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }

        public static StackAdvisorRequestType fromString(String text) throws StackAdvisorException {
            if (text != null) {
                for (StackAdvisorRequestType next : StackAdvisorRequestType.values()) {
                    if (!text.equalsIgnoreCase(next.type)) continue;
                    return next;
                }
            }
            throw new StackAdvisorException(String.format("Unknown request type: %s, possible values: %s", text, Arrays.toString((Object[])StackAdvisorRequestType.values())));
        }
    }

    public static class StackAdvisorRequestBuilder {
        StackAdvisorRequest instance;

        private StackAdvisorRequestBuilder(String stackName, String stackVersion) {
            this.instance = new StackAdvisorRequest(stackName, stackVersion);
        }

        public static StackAdvisorRequestBuilder forStack(StackId stackId) {
            return StackAdvisorRequestBuilder.forStack(stackId.getStackName(), stackId.getStackVersion());
        }

        public static StackAdvisorRequestBuilder forStack(String stackName, String stackVersion) {
            return new StackAdvisorRequestBuilder(stackName, stackVersion);
        }

        public StackAdvisorRequestBuilder ofType(StackAdvisorRequestType requestType) {
            this.instance.requestType = requestType;
            return this;
        }

        public StackAdvisorRequestBuilder forHosts(List<String> hosts) {
            this.instance.hosts = hosts;
            return this;
        }

        public StackAdvisorRequestBuilder forServices(Collection<String> services) {
            this.instance.services = services;
            return this;
        }

        public StackAdvisorRequestBuilder withComponentHostsMap(Map<String, Set<String>> componentHostsMap) {
            this.instance.componentHostsMap = componentHostsMap;
            return this;
        }

        public StackAdvisorRequestBuilder forHostComponents(Map<String, Set<String>> hostComponents) {
            this.instance.hostComponents = hostComponents;
            return this;
        }

        public StackAdvisorRequestBuilder forHostsGroupBindings(Map<String, Set<String>> hostGroupBindings) {
            this.instance.hostGroupBindings = hostGroupBindings;
            return this;
        }

        public StackAdvisorRequestBuilder withConfigurations(Map<String, Map<String, Map<String, String>>> configurations) {
            this.instance.configurations = configurations;
            return this;
        }

        public StackAdvisorRequestBuilder withConfigurations(Configuration configuration) {
            Map<String, Map<String, String>> properties = configuration.getFullProperties();
            this.instance.configurations = properties.entrySet().stream().map(e -> Pair.of((Object)((String)e.getKey()), (Object)ImmutableMap.of((Object)"properties", (Object)((Map)e.getValue())))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
            return this;
        }

        public StackAdvisorRequestBuilder withChangedConfigurations(List<ChangedConfigInfo> changedConfigurations) {
            this.instance.changedConfigurations = changedConfigurations;
            return this;
        }

        public StackAdvisorRequestBuilder withUserContext(Map<String, String> userContext) {
            this.instance.userContext = userContext;
            return this;
        }

        public StackAdvisorRequestBuilder withConfigGroups(Set<RecommendationResponse.ConfigGroup> configGroups) {
            this.instance.configGroups = configGroups;
            return this;
        }

        public StackAdvisorRequestBuilder withGPLLicenseAccepted(Boolean gplLicenseAccepted) {
            this.instance.gplLicenseAccepted = gplLicenseAccepted;
            return this;
        }

        public StackAdvisorRequestBuilder withLdapConfig(Map<String, Object> ldapConfig) {
            Preconditions.checkNotNull(ldapConfig);
            this.instance.ldapConfig = ldapConfig;
            return this;
        }

        public StackAdvisorRequestBuilder withClusterId(Long clusterId) {
            this.instance.clusterId = clusterId;
            return this;
        }

        public StackAdvisorRequestBuilder withServiceName(String serviceName) {
            this.instance.serviceName = serviceName;
            return this;
        }

        public StackAdvisorRequestBuilder withConfigsResponse(Boolean configsResponse) {
            this.instance.configsResponse = configsResponse;
            return this;
        }

        public StackAdvisorRequest build() {
            return this.instance;
        }
    }
}

