/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services.stackadvisor;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorException;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorRequest;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorRequestException;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorRunner;
import id.onyx.obdp.server.api.services.stackadvisor.commands.ComponentLayoutRecommendationCommand;
import id.onyx.obdp.server.api.services.stackadvisor.commands.ComponentLayoutValidationCommand;
import id.onyx.obdp.server.api.services.stackadvisor.commands.ConfigurationDependenciesRecommendationCommand;
import id.onyx.obdp.server.api.services.stackadvisor.commands.ConfigurationRecommendationCommand;
import id.onyx.obdp.server.api.services.stackadvisor.commands.ConfigurationValidationCommand;
import id.onyx.obdp.server.api.services.stackadvisor.commands.StackAdvisorCommand;
import id.onyx.obdp.server.api.services.stackadvisor.commands.StackAdvisorCommandType;
import id.onyx.obdp.server.api.services.stackadvisor.recommendations.RecommendationResponse;
import id.onyx.obdp.server.api.services.stackadvisor.validations.ValidationResponse;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.internal.OBDPServerConfigurationHandler;
import id.onyx.obdp.server.state.ServiceInfo;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Singleton
public class StackAdvisorHelper {
    protected static Log LOG = LogFactory.getLog(StackAdvisorHelper.class);
    private File recommendationsDir;
    private String recommendationsArtifactsLifetime;
    private int recommendationsArtifactsRolloverMax;
    private final OBDPMetaInfo metaInfo;
    private final OBDPServerConfigurationHandler ambariServerConfigurationHandler;
    private final Gson gson;
    private int requestId = 0;
    private StackAdvisorRunner saRunner;
    private Map<String, JsonNode> hostInfoCache = new ConcurrentHashMap<String, JsonNode>();
    private Map<String, RecommendationResponse> configsRecommendationResponse = new ConcurrentHashMap<String, RecommendationResponse>();

    @Inject
    public StackAdvisorHelper(Configuration conf, StackAdvisorRunner saRunner, OBDPMetaInfo metaInfo, OBDPServerConfigurationHandler ambariServerConfigurationHandler, Gson gson) throws IOException {
        this.recommendationsDir = conf.getRecommendationsDir();
        this.recommendationsArtifactsLifetime = conf.getRecommendationsArtifactsLifetime();
        this.recommendationsArtifactsRolloverMax = conf.getRecommendationsArtifactsRolloverMax();
        this.saRunner = saRunner;
        this.metaInfo = metaInfo;
        this.ambariServerConfigurationHandler = ambariServerConfigurationHandler;
        this.gson = gson;
    }

    public synchronized ValidationResponse validate(StackAdvisorRequest request) throws StackAdvisorException {
        this.requestId = this.generateRequestId();
        String serviceName = "ZOOKEEPER";
        ServiceInfo.ServiceAdvisorType serviceAdvisorType = this.getServiceAdvisorType(request.getStackName(), request.getStackVersion(), serviceName);
        StackAdvisorCommand<ValidationResponse> command = this.createValidationCommand(serviceName, request);
        return command.invoke(request, serviceAdvisorType);
    }

    StackAdvisorCommand<ValidationResponse> createValidationCommand(String serviceName, StackAdvisorRequest request) throws StackAdvisorException {
        StackAdvisorCommand command;
        StackAdvisorRequest.StackAdvisorRequestType requestType = request.getRequestType();
        ServiceInfo.ServiceAdvisorType serviceAdvisorType = this.getServiceAdvisorType(request.getStackName(), request.getStackVersion(), serviceName);
        if (requestType == StackAdvisorRequest.StackAdvisorRequestType.HOST_GROUPS) {
            command = new ComponentLayoutValidationCommand(this.recommendationsDir, this.recommendationsArtifactsLifetime, serviceAdvisorType, this.requestId, this.saRunner, this.metaInfo, this.ambariServerConfigurationHandler);
        } else if (requestType == StackAdvisorRequest.StackAdvisorRequestType.CONFIGURATIONS) {
            command = new ConfigurationValidationCommand(this.recommendationsDir, this.recommendationsArtifactsLifetime, serviceAdvisorType, this.requestId, this.saRunner, this.metaInfo, this.ambariServerConfigurationHandler);
        } else {
            throw new StackAdvisorRequestException(String.format("Unsupported request type, type=%s", new Object[]{requestType}));
        }
        return command;
    }

    public synchronized RecommendationResponse recommend(StackAdvisorRequest request) throws StackAdvisorException, OBDPException {
        this.requestId = this.generateRequestId();
        String serviceName = "ZOOKEEPER";
        ServiceInfo.ServiceAdvisorType serviceAdvisorType = this.getServiceAdvisorType(request.getStackName(), request.getStackVersion(), serviceName);
        StackAdvisorCommand<RecommendationResponse> command = this.createRecommendationCommand(serviceName, request);
        StackAdvisorRequest.StackAdvisorRequestType requestType = request.getRequestType();
        RecommendationResponse response = null;
        if (requestType == StackAdvisorRequest.StackAdvisorRequestType.CONFIGURATIONS) {
            String hash = this.getHash(request);
            LOG.info((Object)String.format("Calling stack advisor with hash: %s, service: %s", hash, request.getServiceName()));
            response = this.configsRecommendationResponse.computeIfAbsent(hash, h -> {
                try {
                    LOG.info((Object)String.format("Invoking configuration stack advisor command with hash: %s, service: %s", hash, request.getServiceName()));
                    return (RecommendationResponse)command.invoke(request, serviceAdvisorType);
                }
                catch (StackAdvisorException e) {
                    return null;
                }
            });
        }
        return response == null ? command.invoke(request, serviceAdvisorType) : response;
    }

    protected String getHash(StackAdvisorRequest request) {
        String json = this.gson.toJson((Object)request);
        String generatedPassword = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-512");
            md.update("".getBytes("UTF-8"));
            byte[] bytes = md.digest(json.getBytes("UTF-8"));
            StringBuilder sb = new StringBuilder();
            for (byte b : bytes) {
                sb.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
            }
            generatedPassword = sb.toString();
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return generatedPassword;
    }

    StackAdvisorCommand<RecommendationResponse> createRecommendationCommand(String serviceName, StackAdvisorRequest request) throws StackAdvisorException {
        StackAdvisorCommand command;
        StackAdvisorRequest.StackAdvisorRequestType requestType = request.getRequestType();
        ServiceInfo.ServiceAdvisorType serviceAdvisorType = this.getServiceAdvisorType(request.getStackName(), request.getStackVersion(), serviceName);
        if (requestType == StackAdvisorRequest.StackAdvisorRequestType.HOST_GROUPS) {
            command = new ComponentLayoutRecommendationCommand(this.recommendationsDir, this.recommendationsArtifactsLifetime, serviceAdvisorType, this.requestId, this.saRunner, this.metaInfo, this.ambariServerConfigurationHandler);
        } else if (requestType == StackAdvisorRequest.StackAdvisorRequestType.CONFIGURATIONS) {
            command = new ConfigurationRecommendationCommand(StackAdvisorCommandType.RECOMMEND_CONFIGURATIONS, this.recommendationsDir, this.recommendationsArtifactsLifetime, serviceAdvisorType, this.requestId, this.saRunner, this.metaInfo, this.ambariServerConfigurationHandler, this.hostInfoCache);
        } else if (requestType == StackAdvisorRequest.StackAdvisorRequestType.SSO_CONFIGURATIONS) {
            command = new ConfigurationRecommendationCommand(StackAdvisorCommandType.RECOMMEND_CONFIGURATIONS_FOR_SSO, this.recommendationsDir, this.recommendationsArtifactsLifetime, serviceAdvisorType, this.requestId, this.saRunner, this.metaInfo, this.ambariServerConfigurationHandler, null);
        } else if (requestType == StackAdvisorRequest.StackAdvisorRequestType.LDAP_CONFIGURATIONS) {
            command = new ConfigurationRecommendationCommand(StackAdvisorCommandType.RECOMMEND_CONFIGURATIONS_FOR_LDAP, this.recommendationsDir, this.recommendationsArtifactsLifetime, serviceAdvisorType, this.requestId, this.saRunner, this.metaInfo, this.ambariServerConfigurationHandler, null);
        } else if (requestType == StackAdvisorRequest.StackAdvisorRequestType.KERBEROS_CONFIGURATIONS) {
            command = new ConfigurationRecommendationCommand(StackAdvisorCommandType.RECOMMEND_CONFIGURATIONS_FOR_KERBEROS, this.recommendationsDir, this.recommendationsArtifactsLifetime, serviceAdvisorType, this.requestId, this.saRunner, this.metaInfo, this.ambariServerConfigurationHandler, null);
        } else if (requestType == StackAdvisorRequest.StackAdvisorRequestType.CONFIGURATION_DEPENDENCIES) {
            command = new ConfigurationDependenciesRecommendationCommand(this.recommendationsDir, this.recommendationsArtifactsLifetime, serviceAdvisorType, this.requestId, this.saRunner, this.metaInfo, this.ambariServerConfigurationHandler);
        } else {
            throw new StackAdvisorRequestException(String.format("Unsupported request type, type=%s", new Object[]{requestType}));
        }
        return command;
    }

    private ServiceInfo.ServiceAdvisorType getServiceAdvisorType(String stackName, String stackVersion, String serviceName) {
        try {
            ServiceInfo service = this.metaInfo.getService(stackName, stackVersion, serviceName);
            ServiceInfo.ServiceAdvisorType serviceAdvisorType = service.getServiceAdvisorType();
            return serviceAdvisorType;
        }
        catch (OBDPException oBDPException) {
            return null;
        }
    }

    private int generateRequestId() {
        ++this.requestId;
        return this.requestId % this.recommendationsArtifactsRolloverMax;
    }

    public void clearCaches(String hostName) {
        this.configsRecommendationResponse.clear();
        this.hostInfoCache.remove(hostName);
        LOG.info((Object)("Clear stack advisor caches, host: " + hostName));
    }

    public void clearCaches(Set<String> hostNames) {
        if (hostNames != null && !hostNames.isEmpty()) {
            this.configsRecommendationResponse.clear();
            for (String hostName : hostNames) {
                this.hostInfoCache.remove(hostName);
            }
        }
        LOG.info((Object)("Clear stack advisor caches, hosts: " + hostNames.toString()));
    }
}

