/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services.stackadvisor;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Singleton;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorException;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorHelper;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorRequest;
import id.onyx.obdp.server.api.services.stackadvisor.recommendations.RecommendationResponse;
import id.onyx.obdp.server.controller.internal.ConfigurationTopologyException;
import id.onyx.obdp.server.controller.internal.Stack;
import id.onyx.obdp.server.topology.AdvisedConfiguration;
import id.onyx.obdp.server.topology.Blueprint;
import id.onyx.obdp.server.topology.ClusterTopology;
import id.onyx.obdp.server.topology.ConfigRecommendationStrategy;
import id.onyx.obdp.server.topology.HostGroup;
import id.onyx.obdp.server.topology.HostGroupInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class StackAdvisorBlueprintProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(StackAdvisorBlueprintProcessor.class);
    private static StackAdvisorHelper stackAdvisorHelper;
    static final String RECOMMENDATION_FAILED = "Configuration recommendation failed.";
    static final String INVALID_RESPONSE = "Configuration recommendation returned with invalid response.";
    private static final Map<String, String> userContext;

    public static void init(StackAdvisorHelper instance) {
        stackAdvisorHelper = instance;
    }

    public void adviseConfiguration(ClusterTopology clusterTopology, Map<String, Map<String, String>> userProvidedConfigurations) throws ConfigurationTopologyException {
        StackAdvisorRequest request = this.createStackAdvisorRequest(clusterTopology, StackAdvisorRequest.StackAdvisorRequestType.CONFIGURATIONS);
        try {
            RecommendationResponse response = stackAdvisorHelper.recommend(request);
            this.addAdvisedConfigurationsToTopology(response, clusterTopology, userProvidedConfigurations);
        }
        catch (OBDPException | StackAdvisorException e) {
            throw new ConfigurationTopologyException(RECOMMENDATION_FAILED, e);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationTopologyException(INVALID_RESPONSE, e);
        }
    }

    private StackAdvisorRequest createStackAdvisorRequest(ClusterTopology clusterTopology, StackAdvisorRequest.StackAdvisorRequestType requestType) {
        Stack stack = clusterTopology.getBlueprint().getStack();
        Map<String, Set<String>> hgComponentsMap = this.gatherHostGroupComponents(clusterTopology);
        Map<String, Set<String>> hgHostsMap = this.gatherHostGroupBindings(clusterTopology);
        Map<String, Set<String>> componentHostsMap = this.gatherComponentsHostsMap(hgComponentsMap, hgHostsMap);
        return StackAdvisorRequest.StackAdvisorRequestBuilder.forStack(stack.getName(), stack.getVersion()).forServices(new ArrayList<String>(clusterTopology.getBlueprint().getServices())).forHosts(this.gatherHosts(clusterTopology)).forHostsGroupBindings(this.gatherHostGroupBindings(clusterTopology)).forHostComponents(this.gatherHostGroupComponents(clusterTopology)).withComponentHostsMap(componentHostsMap).withConfigurations(this.calculateConfigs(clusterTopology)).withUserContext(userContext).ofType(requestType).build();
    }

    private Map<String, Set<String>> gatherHostGroupBindings(ClusterTopology clusterTopology) {
        HashMap hgBindngs = Maps.newHashMap();
        for (Map.Entry<String, HostGroupInfo> hgEnrty : clusterTopology.getHostGroupInfo().entrySet()) {
            hgBindngs.put(hgEnrty.getKey(), Sets.newCopyOnWriteArraySet(hgEnrty.getValue().getHostNames()));
        }
        return hgBindngs;
    }

    private Map<String, Set<String>> gatherHostGroupComponents(ClusterTopology clusterTopology) {
        HashMap hgComponentsMap = Maps.newHashMap();
        for (Map.Entry<String, HostGroup> hgEnrty : clusterTopology.getBlueprint().getHostGroups().entrySet()) {
            hgComponentsMap.put(hgEnrty.getKey(), Sets.newCopyOnWriteArraySet(hgEnrty.getValue().getComponentNames()));
        }
        return hgComponentsMap;
    }

    private Map<String, Map<String, Map<String, String>>> calculateConfigs(ClusterTopology clusterTopology) {
        HashMap result = Maps.newHashMap();
        Map<String, Map<String, String>> fullProperties = clusterTopology.getConfiguration().getFullProperties();
        for (Map.Entry<String, Map<String, String>> siteEntry : fullProperties.entrySet()) {
            HashMap propsMap = Maps.newHashMap();
            propsMap.put("properties", siteEntry.getValue());
            result.put(siteEntry.getKey(), propsMap);
        }
        return result;
    }

    private Map<String, Set<String>> gatherComponentsHostsMap(Map<String, Set<String>> hostGroups, Map<String, Set<String>> bindingHostGroups) {
        HashMap<String, Set<String>> componentHostsMap = new HashMap<String, Set<String>>();
        if (null != bindingHostGroups && null != hostGroups) {
            for (Map.Entry<String, Set<String>> hgComponents : hostGroups.entrySet()) {
                String hgName = hgComponents.getKey();
                Set<String> components = hgComponents.getValue();
                Set<String> hosts = bindingHostGroups.get(hgName);
                if (hosts == null) continue;
                for (String component : components) {
                    HashSet<String> componentHosts = (HashSet<String>)componentHostsMap.get(component);
                    if (componentHosts == null) {
                        componentHosts = new HashSet<String>();
                        componentHostsMap.put(component, componentHosts);
                    }
                    componentHosts.addAll(hosts);
                }
            }
        }
        return componentHostsMap;
    }

    private List<String> gatherHosts(ClusterTopology clusterTopology) {
        ArrayList hosts = Lists.newArrayList();
        for (Map.Entry<String, HostGroupInfo> entry : clusterTopology.getHostGroupInfo().entrySet()) {
            hosts.addAll(entry.getValue().getHostNames());
        }
        return hosts;
    }

    private void addAdvisedConfigurationsToTopology(RecommendationResponse response, ClusterTopology topology, Map<String, Map<String, String>> userProvidedConfigurations) {
        Preconditions.checkArgument((response.getRecommendations() != null ? 1 : 0) != 0, (Object)"Recommendation response is empty.");
        Preconditions.checkArgument((response.getRecommendations().getBlueprint() != null ? 1 : 0) != 0, (Object)"Blueprint field is missing from the recommendation response.");
        Preconditions.checkArgument((response.getRecommendations().getBlueprint().getConfigurations() != null ? 1 : 0) != 0, (Object)"Configurations are missing from the recommendation blueprint response.");
        Map<String, RecommendationResponse.BlueprintConfigurations> recommendedConfigurations = response.getRecommendations().getBlueprint().getConfigurations();
        Blueprint blueprint = topology.getBlueprint();
        for (Map.Entry<String, RecommendationResponse.BlueprintConfigurations> configEntry : recommendedConfigurations.entrySet()) {
            String configType = configEntry.getKey();
            if (!blueprint.isValidConfigType(configType)) continue;
            RecommendationResponse.BlueprintConfigurations blueprintConfig = this.filterBlueprintConfig(configType, configEntry.getValue(), userProvidedConfigurations, topology);
            topology.getAdvisedConfigurations().put(configType, new AdvisedConfiguration(blueprintConfig.getProperties(), blueprintConfig.getPropertyAttributes()));
        }
    }

    private RecommendationResponse.BlueprintConfigurations filterBlueprintConfig(String configType, RecommendationResponse.BlueprintConfigurations config, Map<String, Map<String, String>> userProvidedConfigurations, ClusterTopology topology) {
        if ((topology.getConfigRecommendationStrategy() == ConfigRecommendationStrategy.ONLY_STACK_DEFAULTS_APPLY || topology.getConfigRecommendationStrategy() == ConfigRecommendationStrategy.ALWAYS_APPLY_DONT_OVERRIDE_CUSTOM_VALUES) && userProvidedConfigurations.containsKey(configType)) {
            RecommendationResponse.BlueprintConfigurations newConfig = new RecommendationResponse.BlueprintConfigurations();
            Map filteredProps = Maps.filterKeys(config.getProperties(), (Predicate)Predicates.not((Predicate)Predicates.in(userProvidedConfigurations.get(configType).keySet())));
            newConfig.setProperties(Maps.newHashMap((Map)filteredProps));
            if (config.getPropertyAttributes() != null) {
                Map filteredAttributes = Maps.filterKeys(config.getPropertyAttributes(), (Predicate)Predicates.not((Predicate)Predicates.in(userProvidedConfigurations.get(configType).keySet())));
                newConfig.setPropertyAttributes(Maps.newHashMap((Map)filteredAttributes));
            }
            return newConfig;
        }
        return config;
    }

    static {
        userContext = new HashMap<String, String>();
        userContext.put("operation", "ClusterCreate");
    }
}

