/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services.serializers;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import id.onyx.obdp.server.api.services.DeleteResultMetadata;
import id.onyx.obdp.server.api.services.Result;
import id.onyx.obdp.server.api.services.ResultMetadata;
import id.onyx.obdp.server.api.services.ResultStatus;
import id.onyx.obdp.server.api.services.serializers.ResultSerializer;
import id.onyx.obdp.server.api.util.TreeNode;
import id.onyx.obdp.server.api.util.TreeNodeImpl;
import id.onyx.obdp.server.controller.internal.OperationStatusMetaData;
import id.onyx.obdp.server.controller.spi.Resource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public class JsonSerializer
implements ResultSerializer {
    JsonFactory m_factory = new JsonFactory();
    ObjectMapper m_mapper = new ObjectMapper(this.m_factory);
    JsonGenerator m_generator;

    @Override
    public Object serialize(Result result) {
        try {
            ByteArrayOutputStream bytesOut = this.init();
            if (result.getStatus().isErrorState()) {
                return this.serializeError(result.getStatus());
            }
            TreeNode<Resource> treeNode = result.getResultTree();
            this.processNode(treeNode);
            this.processResultMetadata(result.getResultMetadata());
            this.m_generator.close();
            return bytesOut.toString("UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to serialize to json: " + e, e);
        }
    }

    @Override
    public Object serializeError(ResultStatus error) {
        try {
            ByteArrayOutputStream bytesOut = this.init();
            this.m_generator.writeStartObject();
            this.m_generator.writeNumberField("status", error.getStatus().getStatus());
            this.m_generator.writeStringField("message", error.getMessage());
            this.m_generator.writeEndObject();
            this.m_generator.close();
            return bytesOut.toString("UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to serialize to json: " + e, e);
        }
    }

    private ByteArrayOutputStream init() throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        this.m_generator = this.createJsonGenerator(bytesOut);
        Lf2SpacesIndenter indenter = new Lf2SpacesIndenter();
        DefaultPrettyPrinter p = new DefaultPrettyPrinter();
        p.indentObjectsWith((DefaultPrettyPrinter.Indenter)indenter);
        p.indentArraysWith((DefaultPrettyPrinter.Indenter)indenter);
        this.m_generator.setPrettyPrinter((PrettyPrinter)p);
        return bytesOut;
    }

    private void processResultMetadata(ResultMetadata resultMetadata) throws IOException {
        if (resultMetadata == null) {
            return;
        }
        if (resultMetadata.getClass() == DeleteResultMetadata.class) {
            this.processResultMetadata((DeleteResultMetadata)resultMetadata);
        } else if (resultMetadata.getClass() == OperationStatusMetaData.class) {
            this.processResultMetadata((OperationStatusMetaData)resultMetadata);
        } else {
            throw new IllegalArgumentException("ResultDetails is not of type DeleteResultDetails, cannot parse");
        }
    }

    private void processResultMetadata(DeleteResultMetadata deleteResultMetadata) throws IOException {
        this.m_generator.writeStartObject();
        this.m_generator.writeArrayFieldStart("deleteResult");
        for (String string : deleteResultMetadata.getDeletedKeys()) {
            this.m_generator.writeStartObject();
            this.m_generator.writeObjectFieldStart("deleted");
            this.m_generator.writeStringField("key", string);
            this.m_generator.writeEndObject();
            this.m_generator.writeEndObject();
        }
        for (Map.Entry entry : deleteResultMetadata.getExcptions().entrySet()) {
            ResultStatus resultStatus = (ResultStatus)entry.getValue();
            this.m_generator.writeStartObject();
            this.m_generator.writeObjectFieldStart("error");
            this.m_generator.writeStringField("key", (String)entry.getKey());
            this.m_generator.writeNumberField("code", resultStatus.getStatusCode());
            this.m_generator.writeStringField("message", resultStatus.getMessage());
            this.m_generator.writeEndObject();
            this.m_generator.writeEndObject();
        }
        this.m_generator.writeEndArray();
        this.m_generator.writeEndObject();
    }

    private void processResultMetadata(OperationStatusMetaData metaData) throws IOException {
        this.m_generator.writeStartObject();
        this.m_generator.writeObjectFieldStart("operationResults");
        for (OperationStatusMetaData.Result result : metaData.getResults()) {
            this.m_generator.writeObjectFieldStart(result.getId());
            this.m_generator.writeStringField("status", result.isSuccess() ? "success" : "error");
            if (result.getMessage() != null) {
                this.m_generator.writeStringField("message", result.getMessage());
            }
            if (result.getResponse() != null) {
                this.m_generator.writeFieldName("response");
                this.m_mapper.writeValue(this.m_generator, result.getResponse());
            }
            this.m_generator.writeEndObject();
        }
        this.m_generator.writeEndObject();
        this.m_generator.writeEndObject();
    }

    private void processNode(TreeNode<Resource> node) throws IOException {
        if (this.isObject(node)) {
            this.m_generator.writeStartObject();
            this.writeHref(node);
            this.writeItemCount(node);
            Resource r = node.getObject();
            if (r != null) {
                this.handleResourceProperties(this.getTreeProperties(r.getPropertiesMap()));
            }
        }
        if (this.isArray(node)) {
            if (node.getName() != null) {
                this.m_generator.writeArrayFieldStart(node.getName());
            } else {
                this.m_generator.writeStartArray();
            }
        }
        for (TreeNode<Resource> child : node.getChildren()) {
            this.processNode(child);
        }
        if (this.isArray(node)) {
            this.m_generator.writeEndArray();
        }
        if (this.isObject(node)) {
            this.m_generator.writeEndObject();
        }
    }

    private boolean isObject(TreeNode<Resource> node) {
        return node.getObject() != null || node.getName() != null && (node.getParent() == null || !this.isObject(node.getParent()));
    }

    private boolean isArray(TreeNode<Resource> node) {
        return node.getObject() == null && node.getName() != null || node.getObject() == null && node.getName() == null && node.getChildren().size() > 1;
    }

    private TreeNode<Map<String, Object>> getTreeProperties(Map<String, Map<String, Object>> propertiesMap) {
        TreeNodeImpl<Map<String, Object>> treeProperties = new TreeNodeImpl<Map<String, Object>>(null, new LinkedHashMap(), null);
        for (Map.Entry<String, Map<String, Object>> entry : propertiesMap.entrySet()) {
            TreeNode<Map<String, Object>> node;
            String category = entry.getKey();
            if (category == null || category.isEmpty()) {
                node = treeProperties;
            } else {
                node = treeProperties.getChild(category);
                if (node == null) {
                    String[] tokens = category.split("/");
                    node = treeProperties;
                    for (String t : tokens) {
                        TreeNode<Map<String, Object>> child = node.getChild(t);
                        if (child == null) {
                            child = node.addChild(new LinkedHashMap(), t);
                        }
                        node = child;
                    }
                }
            }
            Map<String, Object> properties = entry.getValue();
            for (Map.Entry<String, Object> propertyEntry : properties.entrySet()) {
                node.getObject().put(propertyEntry.getKey(), propertyEntry.getValue());
            }
        }
        return treeProperties;
    }

    private void handleResourceProperties(TreeNode<Map<String, Object>> node) throws IOException {
        String category = node.getName();
        if (category != null) {
            this.m_generator.writeFieldName(category);
            this.m_generator.writeStartObject();
        }
        for (Map.Entry<String, Object> entry : node.getObject().entrySet()) {
            this.m_generator.writeFieldName(entry.getKey());
            this.m_mapper.writeValue(this.m_generator, entry.getValue());
        }
        for (TreeNode treeNode : node.getChildren()) {
            this.handleResourceProperties(treeNode);
        }
        if (category != null) {
            this.m_generator.writeEndObject();
        }
    }

    private JsonGenerator createJsonGenerator(ByteArrayOutputStream baos) throws IOException {
        JsonGenerator generator = this.m_factory.createJsonGenerator((Writer)new OutputStreamWriter((OutputStream)baos, Charset.forName("UTF-8").newEncoder()));
        Lf2SpacesIndenter indenter = new Lf2SpacesIndenter();
        DefaultPrettyPrinter p = new DefaultPrettyPrinter();
        p.indentObjectsWith((DefaultPrettyPrinter.Indenter)indenter);
        p.indentArraysWith((DefaultPrettyPrinter.Indenter)indenter);
        generator.setPrettyPrinter((PrettyPrinter)p);
        return generator;
    }

    private void writeHref(TreeNode<Resource> node) throws IOException {
        String hrefProp = node.getStringProperty("href");
        if (hrefProp != null) {
            this.m_generator.writeStringField("href", hrefProp);
        }
    }

    private void writeItemCount(TreeNode<Resource> node) throws IOException {
        String countProp = node.getStringProperty("count");
        if (countProp != null) {
            this.m_generator.writeStringField("itemTotal", countProp);
            node.setProperty("count", null);
        }
    }

    private static class Lf2SpacesIndenter
    implements DefaultPrettyPrinter.Indenter {
        static final String SYSTEM_LINE_SEPARATOR;
        static final int SPACE_COUNT = 64;
        static final char[] SPACES;

        public boolean isInline() {
            return false;
        }

        public void writeIndentation(JsonGenerator jg, int level) throws IOException, JsonGenerationException {
            jg.writeRaw(SYSTEM_LINE_SEPARATOR);
            level += level;
            while (level > 64) {
                jg.writeRaw(SPACES, 0, 64);
                level -= SPACES.length;
            }
            jg.writeRaw(SPACES, 0, level);
        }

        static {
            String lf = null;
            try {
                lf = System.getProperty("line.separator");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            SYSTEM_LINE_SEPARATOR = lf == null ? "\n" : lf;
            SPACES = new char[64];
            Arrays.fill(SPACES, ' ');
        }
    }
}

