/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services.serializers;

import id.onyx.obdp.server.api.services.Result;
import id.onyx.obdp.server.api.services.ResultStatus;
import id.onyx.obdp.server.api.services.serializers.ResultSerializer;
import id.onyx.obdp.server.api.util.TreeNode;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.utils.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class CsvSerializer
implements ResultSerializer {
    public static final String PROPERTY_COLUMN_MAP = "csv_column_map";
    public static final String PROPERTY_COLUMN_ORDER = "csv_column_order";

    @Override
    public Object serialize(Result result) {
        if (result.getStatus().isErrorState()) {
            return this.serializeError(result.getStatus());
        }
        CSVPrinter csvPrinter = null;
        try {
            StringBuffer buffer = new StringBuffer();
            TreeNode<Resource> root = result.getResultTree();
            if (root != null) {
                csvPrinter = new CSVPrinter((Appendable)buffer, CSVFormat.DEFAULT);
                if ("true".equalsIgnoreCase(root.getStringProperty("isCollection"))) {
                    List<String> fieldNameOrder = this.processHeader(csvPrinter, root);
                    Collection<TreeNode<Resource>> children = root.getChildren();
                    if (children != null) {
                        for (TreeNode<Resource> child : children) {
                            this.processRecord(csvPrinter, child, fieldNameOrder);
                        }
                    }
                }
            }
            String string = buffer.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to serialize to csv: " + e, e);
        }
        finally {
            Closeables.closeSilently(csvPrinter);
        }
    }

    @Override
    public Object serializeError(ResultStatus error) {
        String string;
        CSVPrinter csvPrinter = null;
        try {
            StringBuffer buffer = new StringBuffer();
            csvPrinter = new CSVPrinter((Appendable)buffer, CSVFormat.DEFAULT);
            csvPrinter.printRecord(Arrays.asList("status", "message"));
            csvPrinter.printRecord(Arrays.asList(error.getStatus().getStatus(), error.getMessage()));
            string = buffer.toString();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Unable to serialize to csv: " + e, e);
            }
            catch (Throwable throwable) {
                Closeables.closeSilently(csvPrinter);
                throw throwable;
            }
        }
        Closeables.closeSilently((Closeable)csvPrinter);
        return string;
    }

    private void processRecord(CSVPrinter csvPrinter, TreeNode<Resource> node, List<String> fieldNameOrder) throws IOException {
        Resource recordResource;
        if (node != null && (recordResource = node.getObject()) != null) {
            ArrayList<Object> values = new ArrayList<Object>();
            if (fieldNameOrder != null) {
                for (String fieldName : fieldNameOrder) {
                    values.add(recordResource.getPropertyValue(fieldName));
                }
            } else {
                Map<String, Map<String, Object>> properties = recordResource.getPropertiesMap();
                if (properties != null) {
                    for (Map.Entry<String, Map<String, Object>> outer : properties.entrySet()) {
                        Map<String, Object> innerProperties = outer.getValue();
                        if (innerProperties == null) continue;
                        for (Map.Entry<String, Object> inner : innerProperties.entrySet()) {
                            values.add(inner.getValue());
                        }
                    }
                }
            }
            if (!values.isEmpty()) {
                csvPrinter.printRecord(values);
            }
        }
    }

    private List<String> processHeader(CSVPrinter csvPrinter, TreeNode<Resource> node) throws IOException {
        Object object = node.getProperty(PROPERTY_COLUMN_MAP);
        Map header = object instanceof Map ? (Map)object : null;
        object = node.getProperty(PROPERTY_COLUMN_ORDER);
        ArrayList<Object> fieldNameOrder = object instanceof List ? (ArrayList)object : (header != null ? new ArrayList(header.keySet()) : null);
        if (header != null) {
            ArrayList<String> headerNames = new ArrayList<String>();
            for (String fieldName : fieldNameOrder) {
                headerNames.add((String)header.get(fieldName));
            }
            csvPrinter.printRecord(headerNames);
        }
        return fieldNameOrder;
    }
}

