/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services.persistence;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.NamedPropertySet;
import id.onyx.obdp.server.api.services.RequestBody;
import id.onyx.obdp.server.api.services.persistence.PersistenceManager;
import id.onyx.obdp.server.controller.spi.ClusterController;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.Schema;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.ResourceType;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PersistenceManagerImpl
implements PersistenceManager {
    private ClusterController m_controller;

    public PersistenceManagerImpl(ClusterController controller) {
        this.m_controller = controller;
    }

    @Override
    public RequestStatus create(ResourceInstance resource, RequestBody requestBody) throws UnsupportedPropertyException, SystemException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        if (!AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, null, EnumSet.of(RoleAuthorization.CLUSTER_MANAGE_USER_PERSISTED_DATA))) {
            throw new AuthorizationException("The authenticated user does not have authorization to create/store user persisted data.");
        }
        if (resource != null) {
            Map<Resource.Type, String> mapResourceIds = resource.getKeyValueMap();
            Resource.Type type = resource.getResourceDefinition().getType();
            Schema schema = this.m_controller.getSchema(type);
            Set<NamedPropertySet> setProperties = requestBody.getNamedPropertySets();
            if (setProperties.isEmpty()) {
                requestBody.addPropertySet(new NamedPropertySet("", new HashMap<String, Object>()));
            }
            for (NamedPropertySet propertySet : setProperties) {
                for (Map.Entry<Resource.Type, String> entry : mapResourceIds.entrySet()) {
                    String property;
                    Map<String, Object> mapProperties = propertySet.getProperties();
                    if (mapProperties.containsKey(property = schema.getKeyPropertyId(entry.getKey()))) continue;
                    mapProperties.put(property, entry.getValue());
                }
            }
            return this.m_controller.createResources(type, this.createControllerRequest(requestBody));
        }
        throw new NoSuchParentResourceException("Resource is null");
    }

    @Override
    public RequestStatus update(ResourceInstance resource, RequestBody requestBody) throws UnsupportedPropertyException, SystemException, NoSuchParentResourceException, NoSuchResourceException {
        if (!AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, null, EnumSet.of(RoleAuthorization.CLUSTER_MANAGE_USER_PERSISTED_DATA))) {
            throw new AuthorizationException("The authenticated user does not have authorization to update/store user persisted data.");
        }
        Map<Resource.Type, String> mapResourceIds = resource.getKeyValueMap();
        Resource.Type type = resource.getResourceDefinition().getType();
        Schema schema = this.m_controller.getSchema(type);
        Set<NamedPropertySet> setProperties = requestBody.getNamedPropertySets();
        for (NamedPropertySet propertySet : setProperties) {
            for (Map.Entry<Resource.Type, String> entry : mapResourceIds.entrySet()) {
                String property;
                Map<String, Object> mapProperties;
                if (entry.getValue() == null || (mapProperties = propertySet.getProperties()).containsKey(property = schema.getKeyPropertyId(entry.getKey()))) continue;
                mapProperties.put(property, entry.getValue());
            }
        }
        return this.m_controller.updateResources(type, this.createControllerRequest(requestBody), resource.getQuery().getPredicate());
    }

    @Override
    public RequestStatus delete(ResourceInstance resource, RequestBody requestBody) throws UnsupportedPropertyException, SystemException, NoSuchParentResourceException, NoSuchResourceException {
        if (!AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, null, EnumSet.of(RoleAuthorization.CLUSTER_MANAGE_USER_PERSISTED_DATA))) {
            throw new AuthorizationException("The authenticated user does not have authorization to delete/store user persisted data.");
        }
        return this.m_controller.deleteResources(resource.getResourceDefinition().getType(), this.createControllerRequest(requestBody), resource.getQuery().getPredicate());
    }

    protected Request createControllerRequest(RequestBody body) {
        return PropertyHelper.getCreateRequest(body.getPropertySets(), body.getRequestInfoProperties());
    }
}

