/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services.parsers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import id.onyx.obdp.server.api.services.NamedPropertySet;
import id.onyx.obdp.server.api.services.RequestBody;
import id.onyx.obdp.server.api.services.parsers.BodyParseException;
import id.onyx.obdp.server.api.services.parsers.RequestBodyParser;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRequestBodyParser
implements RequestBodyParser {
    private static final Logger LOG = LoggerFactory.getLogger(JsonRequestBodyParser.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    @Override
    public Set<RequestBody> parse(String body) throws BodyParseException {
        HashSet<RequestBody> requestBodySet = new HashSet<RequestBody>();
        RequestBody rootBody = new RequestBody();
        rootBody.setBody(body);
        if (body != null && body.length() != 0) {
            try {
                JsonNode root = mapper.readTree(this.ensureArrayFormat(body));
                Iterator iterator = root.elements();
                while (iterator.hasNext()) {
                    JsonNode node = (JsonNode)iterator.next();
                    HashMap<String, Object> mapProperties = new HashMap<String, Object>();
                    HashMap<String, String> requestInfoProps = new HashMap<String, String>();
                    NamedPropertySet propertySet = new NamedPropertySet("", mapProperties);
                    this.processNode(node, "", propertySet, requestInfoProps);
                    if (!requestInfoProps.isEmpty()) {
                        RequestBody requestBody = new RequestBody();
                        requestBody.setBody(body);
                        for (Map.Entry entry : requestInfoProps.entrySet()) {
                            String key = (String)entry.getKey();
                            String value = (String)entry.getValue();
                            requestBody.addRequestInfoProperty(key, value);
                            if (!key.equals("query")) continue;
                            requestBody.setQueryString(value);
                        }
                        if (!propertySet.getProperties().isEmpty()) {
                            requestBody.addPropertySet(propertySet);
                        }
                        requestBodySet.add(requestBody);
                        continue;
                    }
                    if (!propertySet.getProperties().isEmpty()) {
                        rootBody.addPropertySet(propertySet);
                    }
                    requestBodySet.add(rootBody);
                }
            }
            catch (IOException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Caught exception parsing msg body.");
                    LOG.debug("Message Body: {}", (Object)body, (Object)e);
                }
                throw new BodyParseException(e);
            }
        }
        if (requestBodySet.isEmpty()) {
            requestBodySet.add(rootBody);
        }
        return requestBodySet;
    }

    private void processNode(JsonNode node, String path, NamedPropertySet propertySet, Map<String, String> requestInfoProps) throws IOException {
        Iterator iterator = node.fieldNames();
        while (iterator.hasNext()) {
            String value;
            String name = (String)iterator.next();
            JsonNode child = node.get(name);
            if (child.isArray()) {
                Iterator arrayIter = child.elements();
                LinkedHashSet<Map<String, Object>> arraySet = new LinkedHashSet<Map<String, Object>>();
                ArrayList<String> primitives = new ArrayList<String>();
                while (arrayIter.hasNext()) {
                    JsonNode next = (JsonNode)arrayIter.next();
                    if (next.isValueNode()) {
                        primitives.add(next.asText());
                        continue;
                    }
                    NamedPropertySet arrayPropertySet = new NamedPropertySet(name, new HashMap<String, Object>());
                    this.processNode(next, "", arrayPropertySet, requestInfoProps);
                    arraySet.add(arrayPropertySet.getProperties());
                }
                AbstractCollection properties = primitives.isEmpty() ? arraySet : primitives;
                propertySet.getProperties().put(PropertyHelper.getPropertyId(path, name), properties);
                continue;
            }
            if (child.isContainerNode()) {
                if (name.equals("Body")) {
                    name = "";
                }
                if (name.equals("RequestBodyInfo")) {
                    propertySet.getProperties().put(PropertyHelper.getPropertyId(path, name), child.toString());
                    continue;
                }
                this.processNode(child, (String)(path.isEmpty() ? name : path + "/" + name), propertySet, requestInfoProps);
                continue;
            }
            String string = value = child.isNull() ? null : child.asText();
            if (path.equals("RequestInfo")) {
                requestInfoProps.put(PropertyHelper.getPropertyId(null, name), value);
                continue;
            }
            if (path.startsWith("RequestInfo")) {
                requestInfoProps.put(PropertyHelper.getPropertyId(path.substring("RequestInfo".length() + "/".length()), name), value);
                continue;
            }
            propertySet.getProperties().put(PropertyHelper.getPropertyId(path.equals("Body") ? "" : path, name), value);
        }
    }

    private String ensureArrayFormat(String s) {
        return s.startsWith("[") ? s : "[" + s + "]";
    }
}

