/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services.groups;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.MemberResponse;
import id.onyx.obdp.server.controller.spi.Resource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;

@Path(value="/groups/{groupName}/members")
@Api(value="Groups", description="Endpoint for group specific operations")
public class MemberService
extends BaseService {
    @POST
    @Produces(value={"text/plain"})
    public Response createMember(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="groupName") String groupName) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createMemberResource(groupName, null));
    }

    @POST
    @Path(value="{userName}")
    @Produces(value={"text/plain"})
    public Response createMember(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="groupName") String groupName, @PathParam(value="userName") String userName) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createMemberResource(groupName, userName));
    }

    @DELETE
    @Path(value="{userName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Delete group member", nickname="MemberService#deleteMember", notes="Delete member resource.")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=500, message="Server Error")})
    public Response deleteMember(@Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="group name", required=true) @PathParam(value="groupName") String groupName, @ApiParam(value="user name", required=true) @PathParam(value="userName") String userName) {
        return this.handleRequest(headers, null, ui, Request.Type.DELETE, this.createMemberResource(groupName, userName));
    }

    @GET
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get all group members", nickname="MemberService#getMembers", notes="Returns details of all members.", response=MemberResponse.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter member details", defaultValue="MemberInfo/*", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort members (asc | desc)", defaultValue="MemberInfo/user_name.asc", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive). Valid values are :offset | \"start\"", defaultValue="0", dataType="string", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive). Valid values are :offset | \"end\"", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=MemberResponse.class, responseContainer="List")})
    public Response getMembers(@Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="group name", required=true) @PathParam(value="groupName") String groupName) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createMemberResource(groupName, null));
    }

    @GET
    @Path(value="{userName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get group member", nickname="MemberService#getMember", notes="Returns member details.", response=MemberResponse.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter member details", defaultValue="MemberInfo", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=MemberResponse.class)})
    public Response getMember(@Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="group name", required=true) @PathParam(value="groupName") String groupName, @ApiParam(value="user name", required=true) @PathParam(value="userName") String userName) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createMemberResource(groupName, userName));
    }

    @PUT
    @Produces(value={"text/plain"})
    @ApiOperation(value="Update group members", nickname="MemberService#updateMembers", notes="Updates group member resources.", responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="input parameters in json form", required=true, dataType="id.onyx.obdp.server.controller.MemberRequest", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=500, message="Server Error")})
    public Response updateMembers(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="group name", required=true) @PathParam(value="groupName") String groupName) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createMemberResource(groupName, null));
    }

    private ResourceInstance createMemberResource(String groupName, String userName) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Group, groupName);
        mapIds.put(Resource.Type.Member, userName);
        return this.createResource(Resource.Type.Member, mapIds);
    }
}

