/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services.groups;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.GroupResponse;
import id.onyx.obdp.server.controller.spi.Resource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collections;

@Path(value="/groups/")
@Api(value="Groups", description="Endpoint for group specific operations")
public class GroupService
extends BaseService {
    @GET
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get all groups", nickname="GroupService#getGroups", notes="Returns details of all groups.", response=GroupResponse.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter group details", defaultValue="Groups/*", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort groups (asc | desc)", defaultValue="Groups/group_name.asc", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive). Valid values are :offset | \"start\"", defaultValue="0", dataType="string", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive). Valid values are :offset | \"end\"", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful retrieval of all group entries", response=GroupResponse.class, responseContainer="List")})
    public Response getGroups(@Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createGroupResource(null));
    }

    @GET
    @Path(value="{groupName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get group", nickname="GroupService#getGroup", notes="Returns group details.", response=GroupResponse.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter group details", defaultValue="Groups", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful retrieval of group resource", response=GroupResponse.class)})
    public Response getGroup(@Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="group name", required=true) @PathParam(value="groupName") String groupName) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createGroupResource(groupName));
    }

    @POST
    @Produces(value={"text/plain"})
    @ApiOperation(value="Create new group", nickname="GroupService#createGroup", notes="Creates group resource.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="input parameters in json form", required=true, dataType="id.onyx.obdp.server.controller.GroupRequest", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="successful operation"), @ApiResponse(code=500, message="Server Error")})
    public Response createGroup(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createGroupResource(null));
    }

    @POST
    @Deprecated
    @Path(value="{groupName}")
    @Produces(value={"text/plain"})
    public Response createGroup(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="groupName") String groupName) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createGroupResource(groupName));
    }

    @DELETE
    @Path(value="{groupName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Delete group", nickname="GroupService#deleteGroup", notes="Delete group resource.")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=500, message="Server Error")})
    public Response deleteGroup(@Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="group name", required=true) @PathParam(value="groupName") String groupName) {
        return this.handleRequest(headers, null, ui, Request.Type.DELETE, this.createGroupResource(groupName));
    }

    private ResourceInstance createGroupResource(String groupName) {
        return this.createResource(Resource.Type.Group, Collections.singletonMap(Resource.Type.Group, groupName));
    }
}

