/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.JobService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;

public class WorkflowService
extends BaseService {
    private String clusterName;

    public WorkflowService(String clusterName) {
        this.clusterName = clusterName;
    }

    @GET
    @Path(value="{workflowId}")
    @Produces(value={"text/plain"})
    public Response getWorkflow(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="workflowId") String workflowId) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createWorkflowResource(this.clusterName, workflowId));
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getWorkflows(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createWorkflowResource(this.clusterName, null));
    }

    @Path(value="{workflowId}/jobs")
    public JobService getJobHandler(@PathParam(value="workflowId") String workflowId) {
        return new JobService(this.clusterName, workflowId);
    }

    ResourceInstance createWorkflowResource(String clusterName, String workflowId) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Cluster, clusterName);
        mapIds.put(Resource.Type.Workflow, workflowId);
        return this.createResource(Resource.Type.Workflow, mapIds);
    }
}

