/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;

public class WidgetService
extends BaseService {
    private final String clusterName;

    public WidgetService(String clusterName) {
        this.clusterName = clusterName;
    }

    @GET
    @Path(value="{widgetId}")
    @Produces(value={"text/plain"})
    public Response getService(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="widgetId") String widgetId) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createResource(widgetId));
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getServices(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createResource(null));
    }

    @POST
    @Path(value="{widgetId}")
    @Produces(value={"text/plain"})
    public Response createService(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="widgetId") String widgetId) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createResource(widgetId));
    }

    @POST
    @Produces(value={"text/plain"})
    public Response createServices(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createResource(null));
    }

    @PUT
    @Path(value="{widgetId}")
    @Produces(value={"text/plain"})
    public Response updateService(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="widgetId") String widgetId) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createResource(widgetId));
    }

    @PUT
    @Produces(value={"text/plain"})
    public Response updateServices(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createResource(null));
    }

    @DELETE
    @Path(value="{widgetId}")
    @Produces(value={"text/plain"})
    public Response deleteService(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="widgetId") String widgetId) {
        return this.handleRequest(headers, null, ui, Request.Type.DELETE, this.createResource(widgetId));
    }

    private ResourceInstance createResource(String widgetId) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Cluster, this.clusterName);
        mapIds.put(Resource.Type.Widget, widgetId);
        return this.createResource(Resource.Type.Widget, mapIds);
    }
}

