/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.OperatingSystemService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.codec.binary.Base64;

@Path(value="/version_definitions/")
public class VersionDefinitionService
extends BaseService {
    @GET
    @Produces(value={"text/plain"})
    public Response getServices(@Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createResource(null));
    }

    @GET
    @Path(value="{versionId}")
    @Produces(value={"text/plain"})
    public Response getService(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="versionId") String versionId) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createResource(versionId));
    }

    @Path(value="{versionNumber}/operating_systems")
    public OperatingSystemService getOperatingSystemsHandler(@PathParam(value="versionNumber") String versionNumber) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.VersionDefinition, versionNumber);
        return new OperatingSystemService(mapIds);
    }

    @POST
    @Produces(value={"text/plain"})
    public Response createVersion(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createResource(null));
    }

    @POST
    @Consumes(value={"text/xml"})
    @Produces(value={"text/plain"})
    public Response createVersionByXml(String body, @Context HttpHeaders headers, @Context UriInfo ui) throws Exception {
        String encoded = Base64.encodeBase64String((byte[])body.getBytes("UTF-8"));
        JsonObject obj = new JsonObject();
        obj.addProperty("version_base64", encoded);
        JsonObject payload = new JsonObject();
        payload.add("VersionDefinition", (JsonElement)obj);
        return this.handleRequest(headers, payload.toString(), ui, Request.Type.POST, this.createResource(null));
    }

    protected ResourceInstance createResource(String versionId) {
        return this.createResource(Resource.Type.VersionDefinition, Collections.singletonMap(Resource.Type.VersionDefinition, versionId));
    }
}

