/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.UpgradeGroupService;
import id.onyx.obdp.server.controller.spi.Resource;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;

public class UpgradeService
extends BaseService {
    private String m_clusterName = null;

    UpgradeService(String clusterName) {
        this.m_clusterName = clusterName;
    }

    @POST
    @Produces(value={"text/plain"})
    public Response createUpgrade(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createResourceInstance(null));
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getUpgrades(@Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createResourceInstance(null));
    }

    @GET
    @Path(value="{upgradeId}")
    @Produces(value={"text/plain"})
    public Response getUpgradeItem(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="upgradeId") Long id) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createResourceInstance(id));
    }

    @PUT
    @Path(value="{upgradeId}")
    @Produces(value={"text/plain"})
    public Response updateUpgradeItem(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="upgradeId") Long id) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createResourceInstance(id));
    }

    @Path(value="{upgradeId}/upgrade_groups")
    public UpgradeGroupService getUpgradeGroupHandler(@PathParam(value="upgradeId") String upgradeId) {
        return new UpgradeGroupService(this.m_clusterName, upgradeId);
    }

    private ResourceInstance createResourceInstance(Long upgradeId) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Cluster, this.m_clusterName);
        if (null != upgradeId) {
            mapIds.put(Resource.Type.Upgrade, upgradeId.toString());
        }
        return this.createResource(Resource.Type.Upgrade, mapIds);
    }
}

