/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.TaskService;
import id.onyx.obdp.server.controller.spi.Resource;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;

public class UpgradeItemService
extends BaseService {
    private String m_clusterName = null;
    private String m_upgradeId = null;
    private String m_upgradeGroupId = null;

    UpgradeItemService(String clusterName, String upgradeId, String upgradeGroupId) {
        this.m_clusterName = clusterName;
        this.m_upgradeId = upgradeId;
        this.m_upgradeGroupId = upgradeGroupId;
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getUpgrades(@Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createResourceInstance(null));
    }

    @GET
    @Path(value="{upgradeItemId}")
    @Produces(value={"text/plain"})
    public Response getUpgradeItem(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="upgradeItemId") Long id) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createResourceInstance(id));
    }

    @PUT
    @Path(value="{upgradeItemId}")
    @Produces(value={"text/plain"})
    public Response updateUpgradeItem(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="upgradeItemId") Long id) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createResourceInstance(id));
    }

    @Path(value="{upgradeItemId}/tasks")
    public TaskService getTasks(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="upgradeItemId") Long id) {
        return new TaskService(this.m_clusterName, this.m_upgradeId, id.toString());
    }

    ResourceInstance createResourceInstance(Long upgradeItemId) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Cluster, this.m_clusterName);
        mapIds.put(Resource.Type.Upgrade, this.m_upgradeId);
        mapIds.put(Resource.Type.UpgradeGroup, this.m_upgradeGroupId);
        if (null != upgradeItemId) {
            mapIds.put(Resource.Type.UpgradeItem, upgradeItemId.toString());
        }
        return this.createResource(Resource.Type.UpgradeItem, mapIds);
    }
}

