/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.UpgradeItemService;
import id.onyx.obdp.server.controller.spi.Resource;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;

public class UpgradeGroupService
extends BaseService {
    private String m_clusterName = null;
    private String m_upgradeId = null;

    UpgradeGroupService(String clusterName, String upgradeId) {
        this.m_clusterName = clusterName;
        this.m_upgradeId = upgradeId;
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getGroups(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createResourceInstance(null));
    }

    @GET
    @Path(value="{upgradeGroupId}")
    @Produces(value={"text/plain"})
    public Response getGroup(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="upgradeGroupId") Long id) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createResourceInstance(id));
    }

    @Path(value="{upgradeGroupId}/upgrade_items")
    public UpgradeItemService getUpgradeItemService(@Context HttpHeaders headers, @PathParam(value="upgradeGroupId") Long groupId) {
        return new UpgradeItemService(this.m_clusterName, this.m_upgradeId, groupId.toString());
    }

    private ResourceInstance createResourceInstance(Long groupId) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Cluster, this.m_clusterName);
        mapIds.put(Resource.Type.Upgrade, this.m_upgradeId);
        mapIds.put(Resource.Type.Request, this.m_upgradeId);
        if (null != groupId) {
            mapIds.put(Resource.Type.UpgradeGroup, groupId.toString());
        }
        return this.createResource(Resource.Type.UpgradeGroup, mapIds);
    }
}

