/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;

public class TaskService
extends BaseService {
    private String m_clusterName;
    private String m_requestId;
    private String m_stageId;

    public TaskService(String clusterName, String requestId, String stageId) {
        this.m_clusterName = clusterName;
        this.m_requestId = requestId;
        this.m_stageId = stageId;
    }

    @GET
    @Path(value="{taskId}")
    @Produces(value={"text/plain"})
    public Response getTask(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="taskId") String taskId) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createTaskResource(this.m_clusterName, this.m_requestId, this.m_stageId, taskId));
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getComponents(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createTaskResource(this.m_clusterName, this.m_requestId, this.m_stageId, null));
    }

    ResourceInstance createTaskResource(String clusterName, String requestId, String stageId, String taskId) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Cluster, clusterName);
        mapIds.put(Resource.Type.Request, requestId);
        mapIds.put(Resource.Type.Stage, stageId);
        mapIds.put(Resource.Type.Task, taskId);
        return this.createResource(Resource.Type.Task, mapIds);
    }
}

