/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;

public class TaskAttemptService
extends BaseService {
    private String jobId;
    private String workflowId;
    private String clusterName;

    public TaskAttemptService(String clusterName, String workflowId, String jobId) {
        this.clusterName = clusterName;
        this.workflowId = workflowId;
        this.jobId = jobId;
    }

    @GET
    @Path(value="{taskAttemptId}")
    @Produces(value={"text/plain"})
    public Response getTaskAttempt(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="taskAttemptId") String taskAttemptId) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createTaskAttemptResource(this.clusterName, this.workflowId, this.jobId, taskAttemptId));
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getTaskAttempts(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createTaskAttemptResource(this.clusterName, this.workflowId, this.jobId, null));
    }

    ResourceInstance createTaskAttemptResource(String clusterName, String workflowId, String jobId, String taskAttemptId) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Cluster, clusterName);
        mapIds.put(Resource.Type.Workflow, workflowId);
        mapIds.put(Resource.Type.Job, jobId);
        mapIds.put(Resource.Type.TaskAttempt, taskAttemptId);
        return this.createResource(Resource.Type.TaskAttempt, mapIds);
    }
}

