/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collections;

@Path(value="/targets/")
public class TargetClusterService
extends BaseService {
    @GET
    @Path(value="{targetName}")
    @Produces(value={"text/plain"})
    public Response getTargetCluster(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="targetName") String targetName) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createTargetClusterResource(targetName));
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getTargetClusters(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createTargetClusterResource(null));
    }

    @POST
    @Path(value="{targetName}")
    @Produces(value={"text/plain"})
    public Response createTargetCluster(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="targetName") String targetName) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createTargetClusterResource(targetName));
    }

    @PUT
    @Path(value="{targetName}")
    @Produces(value={"text/plain"})
    public Response updateTargetCluster(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="targetName") String targetName) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createTargetClusterResource(targetName));
    }

    @DELETE
    @Path(value="{targetName}")
    @Produces(value={"text/plain"})
    public Response deleteTargetCluster(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="targetName") String targetName) {
        return this.handleRequest(headers, null, ui, Request.Type.DELETE, this.createTargetClusterResource(targetName));
    }

    ResourceInstance createTargetClusterResource(String targetName) {
        return this.createResource(Resource.Type.DRTargetCluster, Collections.singletonMap(Resource.Type.DRTargetCluster, targetName));
    }
}

