/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.TaskService;
import id.onyx.obdp.server.controller.spi.Resource;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;

public class StageService
extends BaseService {
    private String m_clusterName;
    private String m_requestId;

    public StageService(String clusterName, String requestId) {
        this.m_clusterName = clusterName;
        this.m_requestId = requestId;
    }

    @GET
    @Path(value="{stageId}")
    @Produces(value={"text/plain"})
    public Response getStage(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="stageId") String stageId) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createStageResource(this.m_clusterName, this.m_requestId, stageId));
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getStages(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createStageResource(this.m_clusterName, this.m_requestId, null));
    }

    @Path(value="{stageId}/tasks")
    public TaskService getTaskHandler(@PathParam(value="stageId") String stageId) {
        return new TaskService(this.m_clusterName, this.m_requestId, stageId);
    }

    @PUT
    @Path(value="{stageId}")
    @Produces(value={"text/plain"})
    public Response updateStages(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="stageId") String stageId) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createStageResource(this.m_clusterName, this.m_requestId, stageId));
    }

    @POST
    @Produces(value={"text/plain"})
    public Response createStages(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createStageResource(this.m_clusterName, this.m_requestId, null));
    }

    ResourceInstance createStageResource(String clusterName, String requestId, String stageId) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        if (clusterName != null) {
            mapIds.put(Resource.Type.Cluster, clusterName);
        }
        mapIds.put(Resource.Type.Request, requestId);
        mapIds.put(Resource.Type.Stage, stageId);
        return this.createResource(Resource.Type.Stage, mapIds);
    }
}

