/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.CompatibleRepositoryVersionService;
import id.onyx.obdp.server.api.services.OperatingSystemService;
import id.onyx.obdp.server.api.services.RepositoryVersionService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.ComponentDependencyResponse;
import id.onyx.obdp.server.controller.ExtensionLinkResponse;
import id.onyx.obdp.server.controller.QuickLinksResponse;
import id.onyx.obdp.server.controller.StackArtifactResponse;
import id.onyx.obdp.server.controller.StackConfigurationDependencyResponse;
import id.onyx.obdp.server.controller.StackConfigurationResponse;
import id.onyx.obdp.server.controller.StackResponse;
import id.onyx.obdp.server.controller.StackServiceArtifactResponse;
import id.onyx.obdp.server.controller.StackServiceComponentResponse;
import id.onyx.obdp.server.controller.StackServiceResponse;
import id.onyx.obdp.server.controller.StackVersionResponse;
import id.onyx.obdp.server.controller.ThemeResponse;
import id.onyx.obdp.server.controller.spi.Resource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collections;
import java.util.HashMap;

@Path(value="/stacks/")
@Api(value="Stacks", description="Endpoint for stack specific operations")
public class StacksService
extends BaseService {
    @GET
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get all stacks", nickname="StacksService#getStacks", notes="Returns all stacks.", response=StackResponse.StackResponseSwagger.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter stack details", defaultValue="Stacks/stack_name", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort stack privileges (asc | desc)", defaultValue="Stacks/stack_name.asc", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive).  \"start\" is also accepted.", defaultValue="0", dataType="string", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive).  \"end\" is also accepted.", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getStacks(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createStackResource(null));
    }

    @GET
    @Path(value="{stackName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get a stack", nickname="StacksService#getStack", notes="Returns stack details.", response=StackResponse.StackResponseSwagger.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter stack details", defaultValue="Stacks/*", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getStack(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam @PathParam(value="stackName") String stackName) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createStackResource(stackName));
    }

    @GET
    @Path(value="{stackName}/versions")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get all versions for a stacks", nickname="StacksService#getStackVersions", notes="Returns all versions for a stack.", response=StackVersionResponse.StackVersionResponseSwagger.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter stack version details", defaultValue="Versions/stack_name,Versions/stack_version", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort stack privileges (asc | desc)", defaultValue="Versions/stack_name.asc,Versions/stack_version.asc", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive).  \"start\" is also accepted.", defaultValue="0", dataType="string", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive).  \"end\" is also accepted.", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getStackVersions(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam @PathParam(value="stackName") String stackName) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createStackVersionResource(stackName, null));
    }

    @GET
    @Path(value="{stackName}/versions/{stackVersion}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get details for a stack version", nickname="StacksService#getStackVersion", notes="Returns the details for a stack version.", response=StackVersionResponse.StackVersionResponseSwagger.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter stack version details", defaultValue="Versions/*", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getStackVersion(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam @PathParam(value="stackName") String stackName, @ApiParam @PathParam(value="stackVersion") String stackVersion) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createStackVersionResource(stackName, stackVersion));
    }

    @GET
    @Path(value="{stackName}/versions/{stackVersion}/links")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get extension links for a stack version", nickname="StacksService#getStackVersionLinks", notes="Returns the extension links for a stack version.", response=ExtensionLinkResponse.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter extension link attributes", defaultValue="ExtensionLink/link_id,ExtensionLink/stack_name,ExtensionLink/stack_version,ExtensionLink/extension_name,ExtensionLink/extension_version", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort extension links (asc | desc)", defaultValue="ExtensionLink/link_id.asc,ExtensionLink/stack_name.asc,ExtensionLink/stack_version.asc,ExtensionLink/extension_name.asc,ExtensionLink/extension_version.asc", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive).  \"start\" is also accepted.", defaultValue="0", dataType="string", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive).  \"end\" is also accepted.", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getStackVersionLinks(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam @PathParam(value="stackName") String stackName, @ApiParam @PathParam(value="stackVersion") String stackVersion) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createExtensionLinkResource(stackName, stackVersion, null, null));
    }

    @GET
    @Path(value="{stackName}/versions/{stackVersion}/configurations")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get all configurations for a stack version", nickname="StacksService#getStackLevelConfigurations", notes="Returns all configurations for a stack version.", response=StackConfigurationResponse.StackConfigurationResponseSwagger.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter returned attributes", defaultValue="StackLevelConfigurations/stack_name,StackLevelConfigurations/stack_version,StackLevelConfigurations/property_name", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort configuration (asc | desc)", defaultValue="StackLevelConfigurations/stack_name.asc,StackLevelConfigurations/stack_version.asc,StackLevelConfigurations/property_name.asc ", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive).  \"start\" is also accepted.", defaultValue="0", dataType="string", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive).  \"end\" is also accepted.", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getStackLevelConfigurations(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam @PathParam(value="stackName") String stackName, @ApiParam @PathParam(value="stackVersion") String stackVersion) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createStackLevelConfigurationsResource(stackName, stackVersion, null));
    }

    @GET
    @Path(value="{stackName}/versions/{stackVersion}/configurations/{propertyName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get configuration details for a given property", nickname="StacksService#getStackLevelConfiguration", notes="Returns the configuration details for a given property.", response=StackConfigurationResponse.StackConfigurationResponseSwagger.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter returned attributes", defaultValue="StackLevelConfigurations/*", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getStackLevelConfiguration(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam @PathParam(value="stackName") String stackName, @ApiParam @PathParam(value="stackVersion") String stackVersion, @ApiParam @PathParam(value="serviceName") String serviceName, @ApiParam @PathParam(value="propertyName") String propertyName) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createStackLevelConfigurationsResource(stackName, stackVersion, propertyName));
    }

    @GET
    @Path(value="{stackName}/versions/{stackVersion}/services")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get all services for a stack version", nickname="StacksService#getStackServices", notes="Returns all services for a stack version.", response=StackServiceResponse.StackServiceResponseSwagger.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter returned attributes", defaultValue="StackServices/stack_name,StackServices/stack_version,StackServices/service_name", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort stack services (asc | desc)", defaultValue="StackServices/stack_name.asc,StackServices/stack_version.asc,StackServices/service_name.asc", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive).  \"start\" is also accepted.", defaultValue="0", dataType="string", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive).  \"end\" is also accepted.", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getStackServices(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam @PathParam(value="stackName") String stackName, @ApiParam @PathParam(value="stackVersion") String stackVersion) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createStackServiceResource(stackName, stackVersion, null));
    }

    @GET
    @Path(value="{stackName}/versions/{stackVersion}/services/{serviceName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get stack service details", nickname="StacksService#getStackService", notes="Returns the details of a stack service.", response=StackServiceResponse.StackServiceResponseSwagger.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter returned attributes", defaultValue="StackServices/*", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getStackService(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam @PathParam(value="stackName") String stackName, @ApiParam @PathParam(value="stackVersion") String stackVersion, @ApiParam @PathParam(value="serviceName") String serviceName) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createStackServiceResource(stackName, stackVersion, serviceName));
    }

    @GET
    @Path(value="{stackName}/versions/{stackVersion}/artifacts")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get all stack artifacts", nickname="StacksService#getStackArtifacts", notes="Returns all stack artifacts (e.g: kerberos descriptor, metrics descriptor)", response=StackArtifactResponse.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter returned attributes", defaultValue="Artifacts/artifact_name,Artifacts/stack_name,Artifacts/stack_version", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getStackArtifacts(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam @PathParam(value="stackName") String stackName, @ApiParam @PathParam(value="stackVersion") String stackVersion) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createStackArtifactsResource(stackName, stackVersion, null));
    }

    @GET
    @Path(value="{stackName}/versions/{stackVersion}/artifacts/{artifactName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get stack artifact details", nickname="StacksService#getStackArtifact", notes="Returns the details of a stack artifact", response=StackArtifactResponse.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter returned attributes", defaultValue="Artifacts/*", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getStackArtifact(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="stackName") String stackName, @ApiParam @PathParam(value="stackVersion") String stackVersion, @ApiParam @PathParam(value="artifactName") String artifactName) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createStackArtifactsResource(stackName, stackVersion, artifactName));
    }

    @GET
    @Path(value="{stackName}/versions/{stackVersion}/services/{serviceName}/artifacts")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get all artifacts for a stack service", nickname="StacksService#getStackServiceArtifacts", notes="Returns all stack service artifacts", response=StackServiceArtifactResponse.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter returned attributes", defaultValue="Artifacts/artifact_name,Artifacts/stack_name,Artifacts/stack_version", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort service artifacts (asc | desc)", defaultValue="Artifacts/artifact_name.asc,Artifacts/stack_name.asc,Artifacts/stack_version.asc", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive).  \"start\" is also accepted.", defaultValue="0", dataType="string", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive).  \"end\" is also accepted.", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getStackServiceArtifacts(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam @PathParam(value="stackName") String stackName, @ApiParam @PathParam(value="stackVersion") String stackVersion, @ApiParam @PathParam(value="serviceName") String serviceName) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createStackServiceArtifactsResource(stackName, stackVersion, serviceName, null));
    }

    @GET
    @Path(value="{stackName}/versions/{stackVersion}/services/{serviceName}/themes")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get all themes for a stack service", nickname="StacksService#getStackServiceThemes", notes="Returns all stack themes", response=ThemeResponse.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter returned attributes", defaultValue="ThemeInfo/file_name,ThemeInfo/service_name,ThemeInfo/stack_name,ThemeInfo/stack_version", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort service artifacts (asc | desc)", defaultValue="ThemeInfo/file_name.asc,ThemeInfo/service_name.asc,ThemeInfo/stack_name.asc,ThemeInfo/stack_version.asc", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive).  \"start\" is also accepted.", defaultValue="0", dataType="string", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive).  \"end\" is also accepted.", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getStackServiceThemes(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam @PathParam(value="stackName") String stackName, @ApiParam @PathParam(value="stackVersion") String stackVersion, @ApiParam @PathParam(value="serviceName") String serviceName) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createStackServiceThemesResource(stackName, stackVersion, serviceName, null));
    }

    @GET
    @Path(value="{stackName}/versions/{stackVersion}/services/{serviceName}/themes/{themeName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get theme details for a stack service", nickname="StacksService#getStackServiceTheme", notes="Returns stack service theme details.", response=ThemeResponse.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter returned attributes", defaultValue="ThemeInfo/*", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getStackServiceTheme(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam @PathParam(value="stackName") String stackName, @ApiParam @PathParam(value="stackVersion") String stackVersion, @ApiParam @PathParam(value="serviceName") String serviceName, @ApiParam @PathParam(value="themeName") String themeName) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createStackServiceThemesResource(stackName, stackVersion, serviceName, themeName));
    }

    @GET
    @Path(value="{stackName}/versions/{stackVersion}/services/{serviceName}/quicklinks")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get all quicklinks configurations for a stack service", nickname="StacksService#getStackServiceQuickLinksConfigurations", notes="Returns all quicklinks configurations for a stack service.", response=QuickLinksResponse.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter returned attributes", defaultValue="QuickLinkInfo/file_name,QuickLinkInfo/service_name,QuickLinkInfo/stack_name,QuickLinkInfo/stack_version", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort quick links (asc | desc)", defaultValue="QuickLinkInfo/file_name.asc,QuickLinkInfo/service_name.asc,QuickLinkInfo/stack_name.asc,QuickLinkInfo/stack_version.asc", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive).  \"start\" is also accepted.", defaultValue="0", dataType="string", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive).  \"end\" is also accepted.", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getStackServiceQuickLinksConfigurations(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam @PathParam(value="stackName") String stackName, @ApiParam @PathParam(value="stackVersion") String stackVersion, @ApiParam @PathParam(value="serviceName") String serviceName) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createStackServiceQuickLinksResource(stackName, stackVersion, serviceName, null));
    }

    @GET
    @Path(value="{stackName}/versions/{stackVersion}/services/{serviceName}/quicklinks/{quickLinksConfigurationName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get quicklinks configuration details", nickname="StacksService#getStackServiceQuickLinksConfiguration", notes="Returns the details of a quicklinks configuration.", response=QuickLinksResponse.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter returned attributes", defaultValue="QuickLinkInfo/*", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getStackServiceQuickLinksConfiguration(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam @PathParam(value="stackName") String stackName, @ApiParam @PathParam(value="stackVersion") String stackVersion, @ApiParam @PathParam(value="serviceName") String serviceName, @ApiParam @PathParam(value="quickLinksConfigurationName") String quickLinksConfigurationName) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createStackServiceQuickLinksResource(stackName, stackVersion, serviceName, quickLinksConfigurationName));
    }

    @GET
    @Path(value="{stackName}/versions/{stackVersion}/services/{serviceName}/artifacts/{artifactName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get stack service artifact details", nickname="StacksService#getStackServiceArtifact", notes="Returns the details of a stack service artifact.", response=StackArtifactResponse.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter returned attributes", defaultValue="Artifacts/*", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getStackServiceArtifact(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam @PathParam(value="stackName") String stackName, @ApiParam @PathParam(value="stackVersion") String stackVersion, @ApiParam @PathParam(value="serviceName") String serviceName, @ApiParam @PathParam(value="artifactName") String artifactName) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createStackServiceArtifactsResource(stackName, stackVersion, serviceName, artifactName));
    }

    @GET
    @Path(value="{stackName}/versions/{stackVersion}/services/{serviceName}/configurations")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get all configurations for a stack service", nickname="StacksService#getStackConfigurations", notes="Returns all configurations for a stack service.", response=StackConfigurationResponse.StackConfigurationResponseSwagger.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter returned attributes", defaultValue="StackConfigurations/property_name,StackConfigurations/service_name,StackConfigurations/stack_nameStackConfigurations/stack_version", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort service configurations (asc | desc)", defaultValue="StackConfigurations/property_name.asc,StackConfigurations/service_name.asc,StackConfigurations/stack_name.ascStackConfigurations/stack_version.asc", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive).  \"start\" is also accepted.", defaultValue="0", dataType="string", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive).  \"end\" is also accepted.", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getStackConfigurations(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam @PathParam(value="stackName") String stackName, @ApiParam @PathParam(value="stackVersion") String stackVersion, @ApiParam @PathParam(value="serviceName") String serviceName) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createStackConfigurationResource(stackName, stackVersion, serviceName, null));
    }

    @GET
    @Path(value="{stackName}/versions/{stackVersion}/services/{serviceName}/configurations/{propertyName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get stack service configuration details", nickname="StacksService#getStackConfiguration", notes="Returns the details of a stack service configuration.", response=StackConfigurationResponse.StackConfigurationResponseSwagger.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter returned attributes", defaultValue="StackConfigurations/*", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getStackConfiguration(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam @PathParam(value="stackName") String stackName, @ApiParam @PathParam(value="stackVersion") String stackVersion, @ApiParam @PathParam(value="serviceName") String serviceName, @ApiParam @PathParam(value="propertyName") String propertyName) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createStackConfigurationResource(stackName, stackVersion, serviceName, propertyName));
    }

    @GET
    @Path(value="{stackName}/versions/{stackVersion}/services/{serviceName}/configurations/{propertyName}/dependencies")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get all dependencies for a stack service configuration", nickname="StacksService#getStackConfigurationDependencies", notes="Returns all dependencies for a stack service configuration.", response=StackConfigurationDependencyResponse.StackConfigurationDependencyResponseSwagger.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter returned attributes", defaultValue="StackConfigurationDependency/stack_name,StackConfigurationDependency/stack_version,StackConfigurationDependency/service_name,StackConfigurationDependency/property_name,StackConfigurationDependency/dependency_name", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort configuration dependencies (asc | desc)", defaultValue="StackConfigurationDependency/stack_name.asc,StackConfigurationDependency/stack_version.asc,StackConfigurationDependency/service_name.asc,StackConfigurationDependency/property_name.asc,StackConfigurationDependency/dependency_name.asc", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive).  \"start\" is also accepted.", defaultValue="0", dataType="string", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive).  \"end\" is also accepted.", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getStackConfigurationDependencies(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam @PathParam(value="stackName") String stackName, @ApiParam @PathParam(value="stackVersion") String stackVersion, @ApiParam @PathParam(value="serviceName") String serviceName, @ApiParam @PathParam(value="propertyName") String propertyName) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createStackConfigurationDependencyResource(stackName, stackVersion, serviceName, propertyName));
    }

    @GET
    @Path(value="{stackName}/versions/{stackVersion}/services/{serviceName}/components")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get all components for a stack service", nickname="StacksService#getServiceComponents", notes="Returns all components for a stack service.", response=StackServiceComponentResponse.StackServiceComponentResponseSwagger.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter returned attributes", defaultValue="StackServiceComponents/component_name,StackServiceComponents/service_name,StackServiceComponents/stack_name,StackServiceComponents/stack_version", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort service components (asc | desc)", defaultValue="StackServiceComponents/component_name.asc,StackServiceComponents/service_name.asc,StackServiceComponents/stack_name.asc,StackServiceComponents/stack_version.asc", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive).  \"start\" is also accepted.", defaultValue="0", dataType="string", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive).  \"end\" is also accepted.", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getServiceComponents(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam @PathParam(value="stackName") String stackName, @ApiParam @PathParam(value="stackVersion") String stackVersion, @ApiParam @PathParam(value="serviceName") String serviceName) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createStackServiceComponentResource(stackName, stackVersion, serviceName, null));
    }

    @GET
    @Path(value="{stackName}/versions/{stackVersion}/services/{serviceName}/components/{componentName}/dependencies")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get all dependencies for a stack service component", nickname="StacksService#getServiceComponentDependencies", notes="Returns all dependencies for a stack service component.", response=ComponentDependencyResponse.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter returned attributes", defaultValue="Dependencies/stack_name,Dependencies/stack_version,Dependencies/dependent_service_name,Dependencies/dependent_component_name,Dependencies/component_name", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort component dependencies (asc | desc)", defaultValue="Dependencies/stack_name.asc,Dependencies/stack_version.asc,Dependencies/dependent_service_name.asc,Dependencies/dependent_component_name.asc,Dependencies/component_name.asc", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive).  \"start\" is also accepted.", defaultValue="0", dataType="string", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive).  \"end\" is also accepted.", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getServiceComponentDependencies(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam @PathParam(value="stackName") String stackName, @ApiParam @PathParam(value="stackVersion") String stackVersion, @ApiParam @PathParam(value="serviceName") String serviceName, @ApiParam @PathParam(value="componentName") String componentName) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createStackServiceComponentDependencyResource(stackName, stackVersion, serviceName, componentName, null));
    }

    @GET
    @Path(value="{stackName}/versions/{stackVersion}/services/{serviceName}/components/{componentName}/dependencies/{dependencyName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get a stack service component dependency", nickname="StacksService#getServiceComponentDependency", notes="Returns a stack service component dependency.", response=ComponentDependencyResponse.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter returned attributes", defaultValue="Dependencies/*", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getServiceComponentDependency(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam @PathParam(value="stackName") String stackName, @ApiParam @PathParam(value="stackVersion") String stackVersion, @ApiParam @PathParam(value="serviceName") String serviceName, @ApiParam @PathParam(value="componentName") String componentName, @ApiParam @PathParam(value="dependencyName") String dependencyName) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createStackServiceComponentDependencyResource(stackName, stackVersion, serviceName, componentName, dependencyName));
    }

    @GET
    @Path(value="{stackName}/versions/{stackVersion}/services/{serviceName}/components/{componentName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get details for a stack service component", nickname="StacksService#getServiceComponent", notes="Returns details for a stack service component.", response=StackServiceComponentResponse.StackServiceComponentResponseSwagger.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter returned attributes", defaultValue="StackServiceComponents/*", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getServiceComponent(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam @PathParam(value="stackName") String stackName, @ApiParam @PathParam(value="stackVersion") String stackVersion, @ApiParam @PathParam(value="serviceName") String serviceName, @ApiParam @PathParam(value="componentName") String componentName) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createStackServiceComponentResource(stackName, stackVersion, serviceName, componentName));
    }

    @Path(value="{stackName}/versions/{stackVersion}/operating_systems")
    public OperatingSystemService getOperatingSystemsHandler(@ApiParam @PathParam(value="stackName") String stackName, @ApiParam @PathParam(value="stackVersion") String stackVersion) {
        HashMap<Resource.Type, String> stackProperties = new HashMap<Resource.Type, String>();
        stackProperties.put(Resource.Type.Stack, stackName);
        stackProperties.put(Resource.Type.StackVersion, stackVersion);
        return new OperatingSystemService(stackProperties);
    }

    @Path(value="{stackName}/versions/{stackVersion}/repository_versions")
    public RepositoryVersionService getRepositoryVersionHandler(@ApiParam @PathParam(value="stackName") String stackName, @ApiParam @PathParam(value="stackVersion") String stackVersion) {
        HashMap<Resource.Type, String> stackProperties = new HashMap<Resource.Type, String>();
        stackProperties.put(Resource.Type.Stack, stackName);
        stackProperties.put(Resource.Type.StackVersion, stackVersion);
        return new RepositoryVersionService(stackProperties);
    }

    @Path(value="{stackName}/versions/{stackVersion}/compatible_repository_versions")
    public CompatibleRepositoryVersionService getCompatibleRepositoryVersionHandler(@ApiParam @PathParam(value="stackName") String stackName, @ApiParam @PathParam(value="stackVersion") String stackVersion) {
        HashMap<Resource.Type, String> stackProperties = new HashMap<Resource.Type, String>();
        stackProperties.put(Resource.Type.Stack, stackName);
        stackProperties.put(Resource.Type.StackVersion, stackVersion);
        return new CompatibleRepositoryVersionService(stackProperties);
    }

    ResourceInstance createStackServiceComponentResource(String stackName, String stackVersion, String serviceName, String componentName) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Stack, stackName);
        mapIds.put(Resource.Type.StackVersion, stackVersion);
        mapIds.put(Resource.Type.StackService, serviceName);
        mapIds.put(Resource.Type.StackServiceComponent, componentName);
        return this.createResource(Resource.Type.StackServiceComponent, mapIds);
    }

    ResourceInstance createStackServiceComponentDependencyResource(String stackName, String stackVersion, String serviceName, String componentName, String dependencyName) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Stack, stackName);
        mapIds.put(Resource.Type.StackVersion, stackVersion);
        mapIds.put(Resource.Type.StackService, serviceName);
        mapIds.put(Resource.Type.StackServiceComponent, componentName);
        mapIds.put(Resource.Type.StackServiceComponentDependency, dependencyName);
        return this.createResource(Resource.Type.StackServiceComponentDependency, mapIds);
    }

    ResourceInstance createStackConfigurationResource(String stackName, String stackVersion, String serviceName, String propertyName) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Stack, stackName);
        mapIds.put(Resource.Type.StackVersion, stackVersion);
        mapIds.put(Resource.Type.StackService, serviceName);
        mapIds.put(Resource.Type.StackConfiguration, propertyName);
        return this.createResource(Resource.Type.StackConfiguration, mapIds);
    }

    ResourceInstance createStackConfigurationDependencyResource(String stackName, String stackVersion, String serviceName, String propertyName) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Stack, stackName);
        mapIds.put(Resource.Type.StackVersion, stackVersion);
        mapIds.put(Resource.Type.StackService, serviceName);
        mapIds.put(Resource.Type.StackConfiguration, propertyName);
        return this.createResource(Resource.Type.StackConfigurationDependency, mapIds);
    }

    ResourceInstance createStackServiceResource(String stackName, String stackVersion, String serviceName) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Stack, stackName);
        mapIds.put(Resource.Type.StackVersion, stackVersion);
        mapIds.put(Resource.Type.StackService, serviceName);
        return this.createResource(Resource.Type.StackService, mapIds);
    }

    ResourceInstance createStackVersionResource(String stackName, String stackVersion) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Stack, stackName);
        mapIds.put(Resource.Type.StackVersion, stackVersion);
        return this.createResource(Resource.Type.StackVersion, mapIds);
    }

    ResourceInstance createStackLevelConfigurationsResource(String stackName, String stackVersion, String propertyName) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Stack, stackName);
        mapIds.put(Resource.Type.StackVersion, stackVersion);
        mapIds.put(Resource.Type.StackLevelConfiguration, propertyName);
        return this.createResource(Resource.Type.StackLevelConfiguration, mapIds);
    }

    ResourceInstance createStackArtifactsResource(String stackName, String stackVersion, String artifactName) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Stack, stackName);
        mapIds.put(Resource.Type.StackVersion, stackVersion);
        mapIds.put(Resource.Type.StackArtifact, artifactName);
        return this.createResource(Resource.Type.StackArtifact, mapIds);
    }

    ResourceInstance createStackServiceArtifactsResource(String stackName, String stackVersion, String serviceName, String artifactName) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Stack, stackName);
        mapIds.put(Resource.Type.StackVersion, stackVersion);
        mapIds.put(Resource.Type.StackService, serviceName);
        mapIds.put(Resource.Type.StackArtifact, artifactName);
        return this.createResource(Resource.Type.StackArtifact, mapIds);
    }

    ResourceInstance createStackServiceThemesResource(String stackName, String stackVersion, String serviceName, String themeName) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Stack, stackName);
        mapIds.put(Resource.Type.StackVersion, stackVersion);
        mapIds.put(Resource.Type.StackService, serviceName);
        mapIds.put(Resource.Type.Theme, themeName);
        return this.createResource(Resource.Type.Theme, mapIds);
    }

    ResourceInstance createStackServiceQuickLinksResource(String stackName, String stackVersion, String serviceName, String quickLinksConfigurationName) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Stack, stackName);
        mapIds.put(Resource.Type.StackVersion, stackVersion);
        mapIds.put(Resource.Type.StackService, serviceName);
        mapIds.put(Resource.Type.QuickLink, quickLinksConfigurationName);
        return this.createResource(Resource.Type.QuickLink, mapIds);
    }

    ResourceInstance createExtensionLinkResource(String stackName, String stackVersion, String extensionName, String extensionVersion) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Stack, stackName);
        mapIds.put(Resource.Type.StackVersion, stackVersion);
        mapIds.put(Resource.Type.Extension, extensionName);
        mapIds.put(Resource.Type.ExtensionVersion, extensionVersion);
        return this.createResource(Resource.Type.ExtensionLink, mapIds);
    }

    ResourceInstance createStackResource(String stackName) {
        return this.createResource(Resource.Type.Stack, Collections.singletonMap(Resource.Type.Stack, stackName));
    }
}

