/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.SettingResponse;
import id.onyx.obdp.server.controller.spi.Resource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collections;

@Path(value="/settings")
@Api(value="Settings", description="Endpoint for settings-specific operations")
public class SettingService
extends BaseService {
    private static final String DEFAULT_FIELDS_GET_SETTINGS = "Settings/name";
    private static final String DEFAULT_FIELDS_GET_SETTING = "Settings/*";
    private static final String SETTING_REQUEST_TYPE = "id.onyx.obdp.server.api.services.SettingRequestSwagger";

    @GET
    @Produces(value={"text/plain"})
    @ApiOperation(value="Returns all settings", response=SettingResponse.SettingResponseWrapper.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", dataType="string", paramType="query", defaultValue="Settings/name"), @ApiImplicitParam(name="sortBy", value="Sort resources in result by (asc | desc)", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive).  \"start\" is also accepted.", allowableValues="range[0, infinity]", defaultValue="0", dataType="integer", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive).  \"end\" is also accepted.", allowableValues="range[1, infinity]", dataType="integer", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getSettings(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        ResourceInstance resource = this.createSettingResource(null);
        return this.handleRequest(headers, body, ui, Request.Type.GET, resource);
    }

    @GET
    @Path(value="{settingName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Returns a specific setting", response=SettingResponse.SettingResponseWrapper.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", dataType="string", paramType="query", defaultValue="Settings/*"), @ApiImplicitParam(name="sortBy", value="Sort resources in result by (asc | desc)", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive).  \"start\" is also accepted.", allowableValues="range[0, infinity]", defaultValue="0", dataType="integer", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive).  \"end\" is also accepted.", allowableValues="range[1, infinity]", dataType="integer", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getSetting(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="setting name", required=true) @PathParam(value="settingName") String settingName) {
        ResourceInstance resource = this.createSettingResource(settingName);
        return this.handleRequest(headers, body, ui, Request.Type.GET, resource);
    }

    @POST
    @Produces(value={"text/plain"})
    @ApiOperation(value="Creates a setting")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.api.services.SettingRequestSwagger", paramType="body", required=true)})
    @ApiResponses(value={@ApiResponse(code=201, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=404, message="Cluster not found"), @ApiResponse(code=409, message="The requested resource already exists."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createSetting(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        ResourceInstance resource = this.createSettingResource(null);
        return this.handleRequest(headers, body, ui, Request.Type.POST, resource);
    }

    @PUT
    @Path(value="{settingName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Updates a setting")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.api.services.SettingRequestSwagger", paramType="body", required=true)})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateSetting(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="setting name", required=true) @PathParam(value="settingName") String settingName) {
        ResourceInstance resource = this.createSettingResource(settingName);
        return this.handleRequest(headers, body, ui, Request.Type.PUT, resource);
    }

    @DELETE
    @Path(value="{settingName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Deletes a setting")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteSetting(@Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="setting name", required=true) @PathParam(value="settingName") String settingName) {
        ResourceInstance resource = this.createSettingResource(settingName);
        return this.handleRequest(headers, null, ui, Request.Type.DELETE, resource);
    }

    protected ResourceInstance createSettingResource(String settingName) {
        return this.createResource(Resource.Type.Setting, Collections.singletonMap(Resource.Type.Setting, settingName));
    }
}

