/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.AlertHistoryService;
import id.onyx.obdp.server.api.services.AlertService;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.ComponentService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.ClusterServiceArtifactResponse;
import id.onyx.obdp.server.controller.ServiceResponse;
import id.onyx.obdp.server.controller.spi.Resource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;

@Api(value="Cluster Services", description="Endpoint for service specific operations")
public class ServiceService
extends BaseService {
    private static final String SERVICE_REQUEST_TYPE = "id.onyx.obdp.server.controller.ServiceRequestSwagger";
    private static final String ARTIFACT_REQUEST_TYPE = "id.onyx.obdp.server.controller.ClusterServiceArtifactRequest";
    private String m_clusterName;

    public ServiceService(String clusterName) {
        this.m_clusterName = clusterName;
    }

    @GET
    @Path(value="{serviceName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get the details of a service", nickname="ServiceService#getService", notes="Returns the details of a service.", response=ServiceResponse.ServiceResponseSwagger.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", defaultValue="ServiceInfo/*", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getService(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam @PathParam(value="serviceName") String serviceName) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createServiceResource(this.m_clusterName, serviceName));
    }

    @GET
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get all services", nickname="ServiceService#getServices", notes="Returns all services.", response=ServiceResponse.ServiceResponseSwagger.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", defaultValue="ServiceInfo/service_name,ServiceInfo/cluster_name", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort resources in result by (asc | desc)", defaultValue="ServiceInfo/service_name.asc,ServiceInfo/cluster_name.asc", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive).  \"start\" is also accepted.", defaultValue="0", dataType="string", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive).  \"end\" is also accepted.", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getServices(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createServiceResource(this.m_clusterName, null));
    }

    @POST
    @Path(value="{serviceName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Creates a service", nickname="ServiceService#createService")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.ServiceRequestSwagger", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=201, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=409, message="The requested resource already exists."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createService(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam @PathParam(value="serviceName") String serviceName) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createServiceResource(this.m_clusterName, serviceName));
    }

    @POST
    @Produces(value={"text/plain"})
    @ApiOperation(value="Creates services", nickname="ServiceService#createServices")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.ServiceRequestSwagger", paramType="body", allowMultiple=true)})
    @ApiResponses(value={@ApiResponse(code=201, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=409, message="The requested resource already exists."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createServices(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createServiceResource(this.m_clusterName, null));
    }

    @PUT
    @Path(value="{serviceName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Updates a service", nickname="ServiceService#updateService")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.ServiceRequestSwagger", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateService(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam @PathParam(value="serviceName") String serviceName) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createServiceResource(this.m_clusterName, serviceName));
    }

    @PUT
    @Produces(value={"text/plain"})
    @ApiOperation(value="Updates multiple services", nickname="ServiceService#updateServices")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.ServiceRequestSwagger", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateServices(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createServiceResource(this.m_clusterName, null));
    }

    @DELETE
    @Path(value="{serviceName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Deletes a service", nickname="ServiceService#deleteService")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteService(@Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(required=true) @PathParam(value="serviceName") String serviceName) {
        return this.handleRequest(headers, null, ui, Request.Type.DELETE, this.createServiceResource(this.m_clusterName, serviceName));
    }

    @Path(value="{serviceName}/components")
    public ComponentService getComponentHandler(@PathParam(value="serviceName") String serviceName) {
        return new ComponentService(this.m_clusterName, serviceName);
    }

    @Path(value="{serviceName}/alerts")
    public AlertService getAlertHandler(@PathParam(value="serviceName") String serviceName) {
        return new AlertService(this.m_clusterName, serviceName, null);
    }

    @POST
    @Path(value="{serviceName}/artifacts/{artifactName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Creates a service artifact", nickname="ServiceService#createArtifact")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.ClusterServiceArtifactRequest", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=201, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=409, message="The requested resource already exists."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createArtifact(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam @PathParam(value="serviceName") String serviceName, @ApiParam @PathParam(value="artifactName") String artifactName) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createArtifactResource(this.m_clusterName, serviceName, artifactName));
    }

    @GET
    @Path(value="{serviceName}/artifacts")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get all service artifacts", nickname="ServiceService#getArtifacts", response=ClusterServiceArtifactResponse.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", defaultValue="Artifacts/artifact_name", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort resources in result by (asc | desc)", defaultValue="Artifacts/artifact_name", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive).  \"start\" is also accepted.", defaultValue="0", dataType="string", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive).  \"end\" is also accepted.", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getArtifacts(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="serviceName") String serviceName) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createArtifactResource(this.m_clusterName, serviceName, null));
    }

    @GET
    @Path(value="{serviceName}/artifacts/{artifactName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get the details of a service artifact", nickname="ServiceService#getArtifact", response=ClusterServiceArtifactResponse.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", defaultValue="Artifacts/artifact_name", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort resources in result by (asc | desc)", defaultValue="Artifacts/artifact_name", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive).  \"start\" is also accepted.", defaultValue="0", dataType="string", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive).  \"end\" is also accepted.", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getArtifact(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam @PathParam(value="serviceName") String serviceName, @ApiParam @PathParam(value="artifactName") String artifactName) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createArtifactResource(this.m_clusterName, serviceName, artifactName));
    }

    @PUT
    @Path(value="{serviceName}/artifacts")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Updates multiple artifacts", nickname="ServiceService#updateArtifacts")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.ClusterServiceArtifactRequest", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateArtifacts(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam @PathParam(value="serviceName") String serviceName) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createArtifactResource(this.m_clusterName, serviceName, null));
    }

    @PUT
    @Path(value="{serviceName}/artifacts/{artifactName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Updates a single artifact", nickname="ServiceService#updateArtifact")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.ClusterServiceArtifactRequest", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateArtifact(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(required=true) @PathParam(value="serviceName") String serviceName, @ApiParam(required=true) @PathParam(value="artifactName") String artifactName) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createArtifactResource(this.m_clusterName, serviceName, artifactName));
    }

    @DELETE
    @Path(value="{serviceName}/artifacts")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Deletes all artifacts of a service that match the provided predicate", nickname="ServiceService#deleteArtifacts")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteArtifacts(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(required=true) @PathParam(value="serviceName") String serviceName) {
        return this.handleRequest(headers, body, ui, Request.Type.DELETE, this.createArtifactResource(this.m_clusterName, serviceName, null));
    }

    @DELETE
    @Path(value="{serviceName}/artifacts/{artifactName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Deletes a single service artifact", nickname="ServiceService#deleteArtifact")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteArtifact(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(required=true) @PathParam(value="serviceName") String serviceName, @ApiParam(required=true) @PathParam(value="artifactName") String artifactName) {
        return this.handleRequest(headers, body, ui, Request.Type.DELETE, this.createArtifactResource(this.m_clusterName, serviceName, artifactName));
    }

    @Path(value="{serviceName}/alert_history")
    public AlertHistoryService getAlertHistoryService(@Context Request request, @PathParam(value="serviceName") String serviceName) {
        return new AlertHistoryService(this.m_clusterName, serviceName, null);
    }

    ResourceInstance createServiceResource(String clusterName, String serviceName) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Cluster, clusterName);
        mapIds.put(Resource.Type.Service, serviceName);
        return this.createResource(Resource.Type.Service, mapIds);
    }

    ResourceInstance createArtifactResource(String clusterName, String serviceName, String artifactName) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Cluster, clusterName);
        mapIds.put(Resource.Type.Service, serviceName);
        mapIds.put(Resource.Type.Artifact, artifactName);
        return this.createResource(Resource.Type.Artifact, mapIds);
    }
}

