/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.RootServiceComponentConfigurationService;
import id.onyx.obdp.server.controller.ApiModel;
import id.onyx.obdp.server.controller.HostResponse;
import id.onyx.obdp.server.controller.RootServiceComponentResponse;
import id.onyx.obdp.server.controller.RootServiceHostComponentResponse;
import id.onyx.obdp.server.controller.RootServiceResponse;
import id.onyx.obdp.server.controller.spi.Resource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Path(value="/services")
@Api(value="Services", description="Endpoint for querying root-level services, ie. Ambari Server and Ambari Agents")
public class RootServiceService
extends BaseService {
    private static final String KEY_COMPONENTS = "components";
    private static final String KEY_HOST_COMPONENTS = "hostComponents";
    private static final String DEFAULT_FIELDS_ROOT_SERVICES = "RootService/service_name";
    private static final String DEFAULT_FIELDS_ROOT_SERVICE = "RootService/service_name, components/RootServiceComponents/component_name, components/RootServiceComponents/service_name";
    private static final String DEFAULT_FIELDS_ROOT_SERVICE_COMPONENTS = "RootServiceComponents/component_name, RootServiceComponents/service_name";
    private static final String DEFAULT_FIELDS_ROOT_SERVICE_COMPONENT = "RootServiceComponents/*, hostComponents/RootServiceHostComponents/component_name, hostComponents/RootServiceHostComponents/host_name, hostComponents/RootServiceHostComponents/service_name";
    private static final String DEFAULT_FIELDS_ROOT_SERVICE_HOST_COMPONENT = "RootServiceHostComponents/component_name, RootServiceHostComponents/host_name, RootServiceHostComponents/service_name";
    private static final String DEFAULT_FIELDS_HOSTS = "Hosts/host_name";
    private static final String DEFAULT_FIELDS_HOST = "Hosts/*";

    @GET
    @Produces(value={"text/plain"})
    @ApiOperation(value="Returns the list of root-level services", response=RootServiceResponseWrapper.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", dataType="string", paramType="query", defaultValue="RootService/service_name")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getRootServices(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        ResourceInstance resource = this.createServiceResource(null);
        return this.handleRequest(headers, body, ui, Request.Type.GET, resource);
    }

    @GET
    @Path(value="{serviceName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Returns information about the given root-level service, including a list of its components", response=RootServiceResponseWithComponentList.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", dataType="string", paramType="query", defaultValue="RootService/service_name, components/RootServiceComponents/component_name, components/RootServiceComponents/service_name")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getRootService(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="service name", required=true) @PathParam(value="serviceName") String serviceName) {
        ResourceInstance resource = this.createServiceResource(serviceName);
        return this.handleRequest(headers, body, ui, Request.Type.GET, resource);
    }

    @GET
    @Path(value="{serviceName}/hosts")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Returns the list of hosts for the given root-level service", response=HostResponse.HostResponseWrapper.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", dataType="string", paramType="query", defaultValue="Hosts/host_name")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getRootHosts(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        ResourceInstance resource = this.createHostResource(null);
        return this.handleRequest(headers, body, ui, Request.Type.GET, resource);
    }

    @GET
    @Path(value="{serviceName}/hosts/{hostName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Returns information about the given host", response=HostResponse.HostResponseWrapper.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", dataType="string", paramType="query", defaultValue="Hosts/*")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getRootHost(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="host name", required=true) @PathParam(value="hostName") String hostName) {
        ResourceInstance resource = this.createHostResource(hostName);
        return this.handleRequest(headers, body, ui, Request.Type.GET, resource);
    }

    @GET
    @Path(value="{serviceName}/hosts/{hostName}/hostComponents")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Returns the list of components for the given root-level service on the given host", response=RootServiceHostComponentResponseWrapper.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", dataType="string", paramType="query", defaultValue="RootServiceHostComponents/component_name, RootServiceHostComponents/host_name, RootServiceHostComponents/service_name")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getRootServiceHostComponents(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="service name", required=true) @PathParam(value="serviceName") String serviceName, @ApiParam(value="host name", required=true) @PathParam(value="hostName") String hostName) {
        ResourceInstance resource = this.createHostComponentResource(serviceName, hostName, null);
        return this.handleRequest(headers, body, ui, Request.Type.GET, resource);
    }

    @GET
    @Path(value="{serviceName}/hosts/{hostName}/hostComponents/{hostComponent}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Returns information about the given component for the given root-level service on the given host", response=RootServiceHostComponentResponseWrapper.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", dataType="string", paramType="query", defaultValue="RootServiceHostComponents/component_name, RootServiceHostComponents/host_name, RootServiceHostComponents/service_name")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getRootServiceHostComponent(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="service name", required=true) @PathParam(value="serviceName") String serviceName, @ApiParam(value="host name", required=true) @PathParam(value="hostName") String hostName, @ApiParam(value="component name", required=true) @PathParam(value="hostComponent") String hostComponent) {
        ResourceInstance resource = this.createHostComponentResource(serviceName, hostName, hostComponent);
        return this.handleRequest(headers, body, ui, Request.Type.GET, resource);
    }

    @GET
    @Path(value="{serviceName}/components")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Returns the list of components for the given root-level service", response=RootServiceComponentResponseWrapper.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", dataType="string", paramType="query", defaultValue="RootServiceComponents/component_name, RootServiceComponents/service_name")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getRootServiceComponents(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="service name", required=true) @PathParam(value="serviceName") String serviceName) {
        ResourceInstance resource = this.createServiceComponentResource(serviceName, null);
        return this.handleRequest(headers, body, ui, Request.Type.GET, resource);
    }

    @GET
    @Path(value="{serviceName}/components/{componentName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Returns information about the given component for the given root-level service", response=RootServiceComponentWithHostComponentList.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", dataType="string", paramType="query", defaultValue="RootServiceComponents/*, hostComponents/RootServiceHostComponents/component_name, hostComponents/RootServiceHostComponents/host_name, hostComponents/RootServiceHostComponents/service_name")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getRootServiceComponent(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="service name", required=true) @PathParam(value="serviceName") String serviceName, @ApiParam(value="component name", required=true) @PathParam(value="componentName") String componentName) {
        ResourceInstance resource = this.createServiceComponentResource(serviceName, componentName);
        return this.handleRequest(headers, body, ui, Request.Type.GET, resource);
    }

    @GET
    @Path(value="{serviceName}/components/{componentName}/hostComponents")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Returns the list of hosts for the given root-level service component", response=RootServiceHostComponentResponseWrapper.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", dataType="string", paramType="query", defaultValue="RootServiceHostComponents/component_name, RootServiceHostComponents/host_name, RootServiceHostComponents/service_name")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getRootServiceComponentHosts(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam(value="service name", required=true) @PathParam(value="serviceName") String serviceName, @ApiParam(value="component name", required=true) @PathParam(value="componentName") String componentName) {
        ResourceInstance resource = this.createHostComponentResource(serviceName, null, componentName);
        return this.handleRequest(headers, body, ui, Request.Type.GET, resource);
    }

    @Path(value="{serviceName}/components/{componentName}/configurations")
    public RootServiceComponentConfigurationService getAmbariServerConfigurationHandler(@Context Request request, @PathParam(value="serviceName") String serviceName, @PathParam(value="componentName") String componentName) {
        return new RootServiceComponentConfigurationService(serviceName, componentName);
    }

    protected ResourceInstance createServiceResource(String serviceName) {
        Map<Resource.Type, String> mapIds = Collections.singletonMap(Resource.Type.RootService, serviceName);
        return this.createResource(Resource.Type.RootService, mapIds);
    }

    protected ResourceInstance createServiceComponentResource(String serviceName, String componentName) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.RootService, serviceName);
        mapIds.put(Resource.Type.RootServiceComponent, componentName);
        return this.createResource(Resource.Type.RootServiceComponent, mapIds);
    }

    protected ResourceInstance createHostResource(String hostName) {
        return this.createResource(Resource.Type.Host, Collections.singletonMap(Resource.Type.Host, hostName));
    }

    protected ResourceInstance createHostComponentResource(String serviceName, String hostName, String componentName) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.RootService, serviceName);
        mapIds.put(Resource.Type.Host, hostName);
        mapIds.put(Resource.Type.RootServiceComponent, componentName);
        return this.createResource(Resource.Type.RootServiceHostComponent, mapIds);
    }

    private static interface RootServiceHostComponentResponseWrapper
    extends ApiModel {
        @ApiModelProperty(name="RootServiceHostComponents")
        public RootServiceHostComponentResponse getRootServiceHostComponentResponse();
    }

    private static interface RootServiceComponentWithHostComponentList
    extends RootServiceComponentResponseWrapper {
        @ApiModelProperty(name="hostComponents")
        public List<RootServiceHostComponentResponseWrapper> getHostComponents();
    }

    private static interface RootServiceComponentResponseWrapper
    extends ApiModel {
        @ApiModelProperty(name="RootServiceComponents")
        public RootServiceComponentResponse getRootServiceComponentResponse();
    }

    private static interface RootServiceResponseWithComponentList
    extends RootServiceResponseWrapper {
        @ApiModelProperty(name="components")
        public List<RootServiceComponentResponseWrapper> getComponents();
    }

    private static interface RootServiceResponseWrapper
    extends ApiModel {
        @ApiModelProperty(name="RootService")
        public RootServiceResponse getRootServiceResponse();
    }
}

