/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.api.resources.BaseResourceDefinition;
import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.RootServiceComponentConfigurationResponseSwagger;
import id.onyx.obdp.server.controller.spi.Resource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@Api(value="Root Service Configurations", description="Endpoint for Ambari root service component configuration related operations")
public class RootServiceComponentConfigurationService
extends BaseService {
    private static final String REQUEST_TYPE = "id.onyx.obdp.server.api.services.RootServiceComponentConfigurationRequestSwagger";
    public static final String DIRECTIVE_OPERATION = "op";
    private static final Set<String> DIRECTIVES = Sets.newHashSet((Object[])new String[]{"op"});
    public static final Map<BaseResourceDefinition.DirectiveType, Set<String>> DIRECTIVES_MAP = ImmutableMap.builder().put((Object)BaseResourceDefinition.DirectiveType.CREATE, DIRECTIVES).put((Object)BaseResourceDefinition.DirectiveType.UPDATE, DIRECTIVES).build();
    private final String serviceName;
    private final String componentName;

    public RootServiceComponentConfigurationService(String serviceName, String componentName) {
        this.serviceName = serviceName;
        this.componentName = componentName;
    }

    @POST
    @Produces(value={"text/plain"})
    @ApiOperation(value="Creates a root service component configuration resource", nickname="RootServiceComponentConfigurationService#createConfiguration")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.api.services.RootServiceComponentConfigurationRequestSwagger", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=201, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=409, message="The requested resource already exists."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createConfiguration(String body, @Context HttpHeaders headers, @Context UriInfo uri) {
        return this.handleRequest(headers, body, uri, Request.Type.POST, this.createResource(null));
    }

    @GET
    @Produces(value={"text/plain"})
    @ApiOperation(value="Retrieve all root service component configuration resources", nickname="RootServiceComponentConfigurationService#getConfigurations", notes="Returns all root service component configurations.", response=RootServiceComponentConfigurationResponseSwagger.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", defaultValue="Configuration/properties, Configuration/category, Configuration/component_name, Configuration/service_name", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort resources in result by (asc | desc)", defaultValue="Configuration/category", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive).  \"start\" is also accepted.", defaultValue="0", dataType="string", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive).  \"end\" is also accepted.", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getConfigurations(String body, @Context HttpHeaders headers, @Context UriInfo uri) {
        return this.handleRequest(headers, body, uri, Request.Type.GET, this.createResource(null));
    }

    @GET
    @Path(value="{category}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Retrieve the details of a root service component configuration resource", nickname="RootServiceComponentConfigurationService#getConfiguration", response=RootServiceComponentConfigurationResponseSwagger.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", defaultValue="Configuration/*", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getConfiguration(String body, @Context HttpHeaders headers, @Context UriInfo uri, @PathParam(value="category") String category) {
        return this.handleRequest(headers, body, uri, Request.Type.GET, this.createResource(category));
    }

    @PUT
    @Path(value="{category}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Updates root service component configuration resources ", nickname="RootServiceComponentConfigurationService#updateConfiguration")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.api.services.RootServiceComponentConfigurationRequestSwagger", paramType="body"), @ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", defaultValue="Configuration/*", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateConfiguration(String body, @Context HttpHeaders headers, @Context UriInfo uri, @PathParam(value="category") String category) {
        return this.handleRequest(headers, body, uri, Request.Type.PUT, this.createResource(category));
    }

    @DELETE
    @Path(value="{category}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Deletes a root service component configuration resource", nickname="RootServiceComponentConfigurationService#deleteConfiguration")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteConfiguration(String body, @Context HttpHeaders headers, @Context UriInfo uri, @PathParam(value="category") String category) {
        return this.handleRequest(headers, body, uri, Request.Type.DELETE, this.createResource(category));
    }

    ResourceInstance createResource(String categoryName) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.RootService, this.serviceName);
        mapIds.put(Resource.Type.RootServiceComponent, this.componentName);
        mapIds.put(Resource.Type.RootServiceComponentConfiguration, categoryName);
        return this.createResource(Resource.Type.RootServiceComponentConfiguration, mapIds);
    }
}

