/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;

@Path(value="/authorizations/")
public class RoleAuthorizationService
extends BaseService {
    private String permissionId;

    public RoleAuthorizationService() {
        this(null);
    }

    public RoleAuthorizationService(String permissionId) {
        this.permissionId = permissionId;
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getAuthorizations(@Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createAuthorizationResource(null));
    }

    @GET
    @Path(value="{authorization_id}")
    @Produces(value={"text/plain"})
    public Response getAuthorization(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="authorization_id") String authorizationId) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createAuthorizationResource(authorizationId));
    }

    protected ResourceInstance createAuthorizationResource(String authorizationId) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Permission, this.permissionId);
        mapIds.put(Resource.Type.RoleAuthorization, authorizationId);
        return this.createResource(Resource.Type.RoleAuthorization, mapIds);
    }
}

