/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

public class ResultStatus {
    private STATUS m_status;
    private String m_msg;

    public ResultStatus(STATUS status, String msg) {
        this.m_status = status;
        this.m_msg = msg;
    }

    public ResultStatus(STATUS status) {
        this.m_status = status;
    }

    public ResultStatus(STATUS status, Exception e) {
        this.m_status = status;
        this.m_msg = e.getMessage();
    }

    public STATUS getStatus() {
        return this.m_status;
    }

    public int getStatusCode() {
        return this.m_status.getStatus();
    }

    public boolean isErrorState() {
        return this.m_status.isErrorState();
    }

    public String getMessage() {
        return this.m_msg;
    }

    public static enum STATUS {
        OK(200, "OK", false),
        CREATED(201, "Created", false),
        ACCEPTED(202, "Accepted", false),
        CONFLICT(409, "Resource Conflict", true),
        NOT_FOUND(404, "Not Found", true),
        BAD_REQUEST(400, "Bad Request", true),
        UNAUTHORIZED(401, "Unauthorized", true),
        FORBIDDEN(403, "Forbidden", true),
        SERVER_ERROR(500, "Internal Server Error", true);

        private int m_code;
        private String m_desc;
        private boolean m_isErrorState;

        private STATUS(int code, String description, boolean isErrorState) {
            this.m_code = code;
            this.m_desc = description;
            this.m_isErrorState = isErrorState;
        }

        public int getStatus() {
            return this.m_code;
        }

        public String getDescription() {
            return this.m_desc;
        }

        public boolean isErrorState() {
            return this.m_isErrorState;
        }

        public String toString() {
            return this.getDescription();
        }
    }
}

