/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.RequestResourceDefinition;
import id.onyx.obdp.server.api.resources.ResourceDefinition;
import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.Result;
import id.onyx.obdp.server.api.services.ResultPostProcessor;
import id.onyx.obdp.server.api.util.TreeNode;
import id.onyx.obdp.server.controller.spi.Resource;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResultPostProcessorImpl
implements ResultPostProcessor {
    private Request m_request;
    Map<Resource.Type, List<ResourceDefinition.PostProcessor>> m_mapPostProcessors = new HashMap<Resource.Type, List<ResourceDefinition.PostProcessor>>();

    public ResultPostProcessorImpl(Request request) {
        this.m_request = request;
        this.registerResourceProcessors(this.m_request.getResource());
    }

    @Override
    public void process(Result result) {
        Object href = this.m_request.getURI();
        int pos = ((String)href).indexOf(63);
        if (pos != -1) {
            try {
                href = ((String)href).substring(0, pos + 1) + URLDecoder.decode(((String)href).substring(pos + 1), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Unable to decode URI: " + e, e);
            }
        }
        this.processNode(result.getResultTree(), (String)href);
    }

    private void processNode(TreeNode<Resource> node, String href) {
        Resource r = node.getObject();
        if (r != null) {
            List<ResourceDefinition.PostProcessor> listProcessors = this.m_mapPostProcessors.get(r.getType());
            for (ResourceDefinition.PostProcessor processor : listProcessors) {
                processor.process(this.m_request, node, href);
            }
            href = node.getStringProperty("href");
            int i = href.indexOf(63);
            if (i != -1) {
                try {
                    href = URLDecoder.decode(href.substring(0, i), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Unable to decode URI: " + e, e);
                }
            }
        } else {
            String isItemsCollection = node.getStringProperty("isCollection");
            if (node.getName() == null && "true".equals(isItemsCollection)) {
                node.setName("items");
                node.setProperty("href", href);
            }
        }
        for (TreeNode<Resource> child : node.getChildren()) {
            this.processNode(child, href);
        }
        this.finalizeNode(node);
    }

    protected void finalizeNode(TreeNode<Resource> node) {
    }

    private void registerResourceProcessors(ResourceInstance resource) {
        Resource.Type type = resource.getResourceDefinition().getType();
        List<ResourceDefinition.PostProcessor> listProcessors = this.m_mapPostProcessors.get(type);
        if (listProcessors == null) {
            listProcessors = new ArrayList<ResourceDefinition.PostProcessor>();
            this.m_mapPostProcessors.put(type, listProcessors);
        }
        listProcessors.addAll(resource.getResourceDefinition().getPostProcessors());
        for (ResourceInstance child : resource.getSubResources().values()) {
            if (this.m_mapPostProcessors.containsKey(child.getResourceDefinition().getType())) continue;
            this.registerResourceProcessors(child);
        }
        this.m_mapPostProcessors.put(Resource.Type.Request, new RequestResourceDefinition().getPostProcessors());
    }
}

