/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.StageService;
import id.onyx.obdp.server.api.services.TaskService;
import id.onyx.obdp.server.controller.RequestPostResponse;
import id.onyx.obdp.server.controller.RequestResponse;
import id.onyx.obdp.server.controller.spi.Resource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;

@Path(value="/requests/")
@Api(value="Requests", description="Endpoint for request specific operations")
public class RequestService
extends BaseService {
    private static final String REQUEST_POST_REQUEST_TYPE = "id.onyx.obdp.server.controller.RequestPostRequest";
    private static final String REQUEST_PUT_REQUEST_TYPE = "id.onyx.obdp.server.controller.RequestPutRequest";
    private String m_clusterName;

    public RequestService() {
    }

    public RequestService(String clusterName) {
        this.m_clusterName = clusterName;
    }

    @GET
    @Path(value="{requestId}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get the details of a request", nickname="RequestService#getRequest", response=RequestResponse.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", defaultValue="Requests/*", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=500, message="Internal server error")})
    public Response getRequest(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam @PathParam(value="requestId") String requestId) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createRequestResource(this.m_clusterName, requestId));
    }

    @GET
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get all requests. A predicate can be given to filter results.", nickname="RequestService#getRequests", response=RequestResponse.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", defaultValue="Requests/id", dataType="string", paramType="query"), @ApiImplicitParam(name="sortBy", value="Sort resources in result by (asc | desc)", defaultValue="Requests/id.asc", dataType="string", paramType="query"), @ApiImplicitParam(name="page_size", value="The number of resources to be returned for the paged response.", defaultValue="10", dataType="integer", paramType="query"), @ApiImplicitParam(name="from", value="The starting page resource (inclusive).  \"start\" is also accepted.", defaultValue="0", dataType="string", paramType="query"), @ApiImplicitParam(name="to", value="The ending page resource (inclusive).  \"end\" is also accepted.", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=500, message="Internal server error")})
    public Response getRequests(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createRequestResource(this.m_clusterName, null));
    }

    @Path(value="{requestId}/stages")
    public StageService getStageHandler(@ApiParam @PathParam(value="requestId") String requestId) {
        return new StageService(this.m_clusterName, requestId);
    }

    @Path(value="{requestId}/tasks")
    public TaskService getTaskHandler(@ApiParam @PathParam(value="requestId") String requestId) {
        return new TaskService(this.m_clusterName, requestId, null);
    }

    @PUT
    @Path(value="{requestId}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Updates a request, usually used to cancel running requests.", notes="Changes the state of an existing request. Usually used to cancel running requests.", nickname="RequestService#updateRequests")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.RequestPutRequest", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateRequests(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam @PathParam(value="requestId") String requestId) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createRequestResource(this.m_clusterName, requestId));
    }

    @POST
    @Produces(value={"text/plain"})
    @ApiOperation(value="Creates one or more Requests", nickname="RequestService#createRequests")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.RequestPostRequest", paramType="body", allowMultiple=true)})
    @ApiResponses(value={@ApiResponse(code=201, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet", response=RequestPostResponse.class), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=409, message="The requested resource already exists."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createRequests(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createRequestResource(this.m_clusterName, null));
    }

    ResourceInstance createRequestResource(String clusterName, String requestId) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        if (null != clusterName) {
            mapIds.put(Resource.Type.Cluster, clusterName);
        }
        mapIds.put(Resource.Type.Request, requestId);
        return this.createResource(Resource.Type.Request, mapIds);
    }
}

