/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.RequestScheduleResponseSwagger;
import id.onyx.obdp.server.controller.spi.Resource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;

@Api(value="RequestSchedules", description="Endpoint for request schedule specific operations")
public class RequestScheduleService
extends BaseService {
    public static final String REQUEST_SCHEDULE_REQUEST_TYPE = "id.onyx.obdp.server.controller.RequestScheduleRequestSwagger";
    private String m_clusterName;

    public RequestScheduleService(String m_clusterName) {
        this.m_clusterName = m_clusterName;
    }

    @GET
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get all request schedules", response=RequestScheduleResponseSwagger.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", defaultValue="RequestSchedule/*", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="Cluster or host not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid arguments")})
    public Response getRequestSchedules(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createRequestSchedule(this.m_clusterName, null));
    }

    @GET
    @Path(value="{requestScheduleId}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get request schedule", response=RequestScheduleResponseSwagger.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", value="Filter fields in the response (identifier fields are mandatory)", defaultValue="RequestSchedule/*", dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="Cluster or host not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid arguments")})
    public Response getRequestSchedule(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="requestScheduleId") String requestScheduleId) {
        return this.handleRequest(headers, body, ui, Request.Type.GET, this.createRequestSchedule(this.m_clusterName, requestScheduleId));
    }

    @POST
    @Produces(value={"text/plain"})
    @ApiOperation(value="Create new request schedule")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.RequestScheduleRequestSwagger", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=201, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=404, message="Cluster not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createRequestSchedule(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createRequestSchedule(this.m_clusterName, null));
    }

    @PUT
    @Path(value="{requestScheduleId}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Updates a scheduled request, usually used to pause running scheduled requests or to resume them.", notes="Changes the state of an existing request. Usually used to pause running scheduled requests or to resume them.", nickname="RequestSchedules#updateRequestSchedule")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="id.onyx.obdp.server.controller.RequestScheduleRequestSwagger", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=202, message="Request is accepted, but not completely processed yet"), @ApiResponse(code=400, message="Invalid arguments"), @ApiResponse(code=404, message="The requested resource doesn't exist."), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateRequestSchedule(String body, @Context HttpHeaders headers, @Context UriInfo ui, @ApiParam @PathParam(value="requestScheduleId") String requestScheduleId) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createRequestSchedule(this.m_clusterName, requestScheduleId));
    }

    @DELETE
    @Path(value="{requestScheduleId}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Delete a request schedule", notes="Changes status from COMPLETED to DISABLED")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=404, message="Cluster or host not found"), @ApiResponse(code=401, message="Not authenticated"), @ApiResponse(code=403, message="Not permitted to perform the operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteRequestSchedule(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="requestScheduleId") String requestScheduleId) {
        return this.handleRequest(headers, null, ui, Request.Type.DELETE, this.createRequestSchedule(this.m_clusterName, requestScheduleId));
    }

    private ResourceInstance createRequestSchedule(String clusterName, String requestScheduleId) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.put(Resource.Type.Cluster, clusterName);
        mapIds.put(Resource.Type.RequestSchedule, requestScheduleId);
        return this.createResource(Resource.Type.RequestSchedule, mapIds);
    }
}

