/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceDefinition;
import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.DeleteRequest;
import id.onyx.obdp.server.api.services.GetRequest;
import id.onyx.obdp.server.api.services.PostRequest;
import id.onyx.obdp.server.api.services.PutRequest;
import id.onyx.obdp.server.api.services.QueryPostRequest;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.RequestBody;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RequestFactory {
    public Request createRequest(HttpHeaders headers, RequestBody body, UriInfo uriInfo, Request.Type requestType, ResourceInstance resource) {
        switch (requestType) {
            case GET: {
                return this.createGetRequest(headers, body, uriInfo, resource);
            }
            case PUT: {
                return this.createPutRequest(headers, body, uriInfo, resource);
            }
            case DELETE: {
                return this.createDeleteRequest(headers, body, uriInfo, resource);
            }
            case POST: {
                return this.createPostRequest(headers, body, uriInfo, resource);
            }
        }
        throw new IllegalArgumentException("Invalid request type: " + requestType);
    }

    private Request createGetRequest(HttpHeaders headers, RequestBody body, UriInfo uriInfo, ResourceInstance resource) {
        this.applyDirectives(Request.Type.GET, body, uriInfo, resource);
        return new GetRequest(headers, body, uriInfo, resource);
    }

    private Request createPostRequest(HttpHeaders headers, RequestBody body, UriInfo uriInfo, ResourceInstance resource) {
        boolean batchCreate = !this.applyDirectives(Request.Type.POST, body, uriInfo, resource);
        return batchCreate ? new QueryPostRequest(headers, body, uriInfo, resource) : new PostRequest(headers, body, uriInfo, resource);
    }

    private Request createPutRequest(HttpHeaders headers, RequestBody body, UriInfo uriInfo, ResourceInstance resource) {
        this.applyDirectives(Request.Type.PUT, body, uriInfo, resource);
        return new PutRequest(headers, body, uriInfo, resource);
    }

    private DeleteRequest createDeleteRequest(HttpHeaders headers, RequestBody body, UriInfo uriInfo, ResourceInstance resource) {
        this.applyDirectives(Request.Type.DELETE, body, uriInfo, resource);
        return new DeleteRequest(headers, body, uriInfo, resource);
    }

    private Map<String, String> getQueryParameters(UriInfo uriInfo, RequestBody body) {
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        for (Map.Entry entry : uriInfo.getQueryParameters().entrySet()) {
            queryParameters.put((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
        }
        String bodyQueryString = body.getQueryString();
        if (bodyQueryString != null && !bodyQueryString.isEmpty()) {
            String[] toks;
            for (String tok : toks = bodyQueryString.split("&")) {
                String[] keyVal = tok.split("=");
                queryParameters.put(keyVal[0], keyVal.length == 2 ? keyVal[1] : "");
            }
        }
        return queryParameters;
    }

    private boolean applyDirectives(Request.Type requestType, RequestBody body, UriInfo uriInfo, ResourceInstance resource) {
        Map<String, String> queryParameters = this.getQueryParameters(uriInfo, body);
        queryParameters.remove("doAs");
        boolean allDirectivesApplicable = true;
        if (!queryParameters.isEmpty()) {
            Collection<String> directives;
            ResourceDefinition resourceDefinition = resource.getResourceDefinition();
            switch (requestType) {
                case PUT: {
                    directives = resourceDefinition.getUpdateDirectives();
                    break;
                }
                case POST: {
                    directives = resourceDefinition.getCreateDirectives();
                    break;
                }
                case GET: {
                    directives = resourceDefinition.getReadDirectives();
                    break;
                }
                case DELETE: {
                    directives = resourceDefinition.getDeleteDirectives();
                    break;
                }
                default: {
                    return false;
                }
            }
            Map<String, String> requestInfoProperties = body.getRequestInfoProperties();
            for (Map.Entry<String, String> entry : queryParameters.entrySet()) {
                if (directives.contains(entry.getKey())) {
                    requestInfoProperties.put(entry.getKey(), entry.getValue());
                    continue;
                }
                allDirectivesApplicable = false;
            }
        }
        return allDirectivesApplicable;
    }
}

