/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;
import java.util.Map;

public class RepositoryService
extends BaseService {
    private Map<Resource.Type, String> parentKeyProperties;

    public RepositoryService(Map<Resource.Type, String> parentKeyProperties) {
        this.parentKeyProperties = parentKeyProperties;
    }

    @POST
    @Produces(value={"text/plain"})
    public Response createRepository(String body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createResource(null));
    }

    @POST
    @Path(value="{repoId}")
    @Produces(value={"text/plain"})
    public Response createRepository(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="repoId") String repoId) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createResource(repoId));
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getRepositories(@Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createResource(null));
    }

    @GET
    @Path(value="{repoId}")
    @Produces(value={"text/plain"})
    public Response getRepository(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="repoId") String repoId) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createResource(repoId));
    }

    @PUT
    @Path(value="{repoId}")
    @Produces(value={"text/plain"})
    public Response updateRepository(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="repoId") String repoId) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createResource(repoId));
    }

    private ResourceInstance createResource(String repoId) {
        HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
        mapIds.putAll(this.parentKeyProperties);
        mapIds.put(Resource.Type.Repository, repoId);
        return this.createResource(Resource.Type.Repository, mapIds);
    }
}

