/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.services;

import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.BaseService;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collections;

@Path(value="/remoteclusters")
public class RemoteClustersService
extends BaseService {
    @GET
    @Produces(value={"text/plain"})
    public Response getRemoteClusters(@Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createRemoteClusterResource(null));
    }

    @POST
    @Path(value="{clusterName}")
    @Produces(value={"text/plain"})
    public Response createRemoteCluster(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="clusterName") String clusterName) {
        return this.handleRequest(headers, body, ui, Request.Type.POST, this.createRemoteClusterResource(clusterName));
    }

    @PUT
    @Path(value="{clusterName}")
    @Produces(value={"text/plain"})
    public Response updateRemoteCluster(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="clusterName") String clusterName) {
        return this.handleRequest(headers, body, ui, Request.Type.PUT, this.createRemoteClusterResource(clusterName));
    }

    @DELETE
    @Path(value="{clusterName}")
    @Produces(value={"text/plain"})
    public Response deleteRemoteCluster(String body, @Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="clusterName") String clusterName) {
        return this.handleRequest(headers, body, ui, Request.Type.DELETE, this.createRemoteClusterResource(clusterName));
    }

    @GET
    @Path(value="{clusterName}")
    @Produces(value={"text/plain"})
    public Response getRemoteCluster(@Context HttpHeaders headers, @Context UriInfo ui, @PathParam(value="clusterName") String clusterName) {
        return this.handleRequest(headers, null, ui, Request.Type.GET, this.createRemoteClusterResource(clusterName));
    }

    private ResourceInstance createRemoteClusterResource(String clusterName) {
        return this.createResource(Resource.Type.RemoteCluster, Collections.singletonMap(Resource.Type.RemoteCluster, clusterName));
    }
}

